/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.types.ByteBuffer;
import ctag.types.Date;

public class PilotDate {
    public int year = 0;
    public byte month = 0;
    public byte day = 0;
    public byte hour = 0;
    public byte minute = 0;
    public byte second = 0;
    public byte unused = 0;

    public void fromBuffer(ByteBuffer byteBuffer, int n) {
        this.year = byteBuffer.getShort(n);
        this.month = byteBuffer.getByte(n + 2);
        this.day = byteBuffer.getByte(n + 3);
        this.hour = byteBuffer.getByte(n + 4);
        this.minute = byteBuffer.getByte(n + 5);
        this.second = byteBuffer.getByte(n + 6);
        this.unused = byteBuffer.getByte(n + 7);
    }

    public void fromCtagDate(Date date) {
        this.year = (short)date.getYear();
        this.month = (byte)date.getMonth();
        this.day = (byte)date.getDate();
    }

    public void fromShort(short s) {
        this.year = ((s & 0xFE00) >> 9) + 4;
        this.month = (byte)((s >> 5 & 0xF) - 1);
        this.day = (byte)(s & 0x1F);
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
    }

    public void fromTime(int n) {
        Date date = new Date((long)n);
        this.year = (short)date.getYear();
        this.month = (byte)date.getMonth();
        this.day = (byte)date.getDate();
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendShort(this.year).appendByte(this.month).appendByte(this.day).appendByte(this.hour).appendByte(this.minute).appendByte(this.second).appendByte(this.unused);
        return byteBuffer;
    }

    public Date toCtagDate() {
        return new Date(this.year, (int)this.month, (int)this.day, (int)this.hour, (int)this.minute, (int)this.second);
    }

    public short toShort() {
        short s = 0;
        s = (short)(s | this.year - 4 << 9);
        s = (short)(s | this.month + 1 << 5);
        s = (short)(s | this.day & 0x1F);
        return s;
    }

    public String toString() {
        return "[Date: " + this.day + "." + (this.month + 1) + "." + this.year + "; Time: " + this.hour + ":" + this.minute + ":" + this.second + "]";
    }
}

