/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.pilot.BinaryFile;
import ctag.pilot.DBInfo;
import ctag.pilot.RecResBase;
import ctag.pilot.Record;
import ctag.pilot.Resource;
import ctag.types.ByteBuffer;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class PilotFile {
    String fieldFileName;
    BinaryFile file;
    boolean hasToBeWritten = false;
    DBInfo fieldDbInfo;
    ByteBuffer fieldAppBlock;
    Vector fieldVecOfRecords;
    ByteBuffer fieldSortInfo;
    int file_size;
    long unique_id_seed;
    int next_record_list_id;
    int ent_hdr_size;
    public static final int PI_HDR_SIZE = 78;
    public static final int PI_RESOURCE_ENT_SIZE = 10;
    public static final int PI_RECORD_ENT_SIZE = 8;

    public PilotFile(File file, String string) throws IOException {
        this.fieldFileName = file.getPath();
        this.file = new BinaryFile(file, string);
    }

    public PilotFile(String string, String string2) throws IOException {
        this.fieldFileName = string;
        this.file = new BinaryFile(string, string2);
    }

    public int append(RecResBase recResBase) {
        this.getRecords().addElement(recResBase);
        return this.getNumOfRecords();
    }

    public void close() throws IOException {
        if (this.hasToBeWritten) {
            this.write();
        }
        this.file.close();
    }

    public ByteBuffer getAppBlock() {
        block2: {
            if (this.fieldAppBlock != null) break block2;
            try {
                this.fieldAppBlock = new ByteBuffer(1);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating AppBlock property.");
            }
        }
        return this.fieldAppBlock;
    }

    private int getAppBlockOffset() {
        if (this.fieldAppBlock == null) {
            return 0;
        }
        return 78 + this.getRecInfoBlockSize() + 2;
    }

    private int getAppBlockSize() {
        if (this.fieldAppBlock == null) {
            return 0;
        }
        return this.fieldAppBlock.getLength();
    }

    public DBInfo getDbInfo() {
        block2: {
            if (this.fieldDbInfo != null) break block2;
            try {
                this.fieldDbInfo = new DBInfo();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating dbInfo property.");
            }
        }
        return this.fieldDbInfo;
    }

    protected BinaryFile getFile() {
        return this.file;
    }

    public int getNumOfRecords() {
        return this.getRecords().size();
    }

    private int getRecInfoBlockSize() {
        return this.getNumOfRecords() * (this.fieldDbInfo.isResource() ? 10 : 8);
    }

    public Record getRecord(int n) {
        return (Record)this.getRecords().elementAt(n);
    }

    public Vector getRecords() {
        block2: {
            if (this.fieldVecOfRecords != null) break block2;
            try {
                this.fieldVecOfRecords = new Vector(30, 5);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating entries property.");
            }
        }
        return this.fieldVecOfRecords;
    }

    public ByteBuffer getSortInfo() {
        block2: {
            if (this.fieldSortInfo != null) break block2;
            try {
                this.fieldSortInfo = new ByteBuffer(1);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating SortInfo property.");
            }
        }
        return this.fieldSortInfo;
    }

    private int getSortInfoOffset() {
        if (this.fieldSortInfo == null) {
            return 0;
        }
        return this.getAppBlockOffset() + this.getAppBlockSize();
    }

    private int getSortInfoSize() {
        if (this.fieldSortInfo == null) {
            return 0;
        }
        return this.fieldSortInfo.getLength();
    }

    public void read() throws IOException {
        RecResBase recResBase;
        ByteBuffer byteBuffer = new ByteBuffer(5);
        int n = (int)this.file.length();
        this.file.seek(0L);
        byte[] byArray = new byte[78];
        this.file.read(byArray);
        byteBuffer.appendData(byArray);
        this.fieldDbInfo = new DBInfo();
        this.fieldDbInfo.name = byteBuffer.getString(0);
        this.fieldDbInfo.flags = byteBuffer.getShort(32);
        this.fieldDbInfo.version = byteBuffer.getShort(34);
        this.fieldDbInfo.createDate.fromCtagDate(byteBuffer.getDate(36));
        this.fieldDbInfo.modifyDate.fromCtagDate(byteBuffer.getDate(40));
        this.fieldDbInfo.backupDate.fromCtagDate(byteBuffer.getDate(44));
        this.fieldDbInfo.modnum = byteBuffer.getInt(48);
        int n2 = byteBuffer.getInt(52);
        int n3 = byteBuffer.getInt(56);
        this.fieldDbInfo.type = byteBuffer.getInt(60);
        this.fieldDbInfo.creatorID = byteBuffer.getInt(64);
        this.unique_id_seed = byteBuffer.getInt(68);
        this.next_record_list_id = byteBuffer.getInt(72);
        int n4 = byteBuffer.getShort(76);
        if (this.next_record_list_id != 0) {
            System.out.println("extended format not supported");
        }
        byArray = new byte[n4 * (this.fieldDbInfo.isResource() ? 10 : 8) + 2];
        this.file.read(byArray);
        byteBuffer.reset();
        byteBuffer.appendData(byArray);
        int n5 = 0;
        int n6 = n;
        int n7 = 0;
        while (n7 < n4) {
            if (this.fieldDbInfo.isResource()) {
                recResBase = new Resource();
                recResBase.fromInfoBuffer(byteBuffer, n5);
                this.getRecords().addElement(recResBase);
                n5 += 10;
            } else {
                recResBase = new Record();
                recResBase.fromInfoBuffer(byteBuffer, n5);
                this.getRecords().addElement(recResBase);
                n5 += 8;
            }
            ++n7;
        }
        int n8 = this.getRecords().size() - 1;
        while (n8 >= 0) {
            recResBase = this.fieldDbInfo.isResource() ? (Resource)this.getRecords().elementAt(n8) : (Record)this.getRecords().elementAt(n8);
            recResBase.size = n6 - recResBase.offset;
            n6 = recResBase.offset;
            --n8;
        }
        int n9 = 0;
        if (n3 != 0) {
            n9 = n6 - n3;
            n6 = n3;
        }
        int n10 = 0;
        if (n2 != 0) {
            n10 = n6 - n2;
            n6 = n2;
        }
        if (n10 != 0) {
            byArray = new byte[n10];
            this.file.read(byArray);
            this.getAppBlock().reset();
            this.getAppBlock().appendData(byArray);
        } else {
            this.fieldAppBlock = null;
        }
        if (n9 != 0) {
            byArray = new byte[n9];
            this.file.read(byArray);
            this.getSortInfo().reset();
            this.getSortInfo().appendData(byArray);
        } else {
            this.fieldSortInfo = null;
        }
        int n11 = 0;
        while (n11 < n4) {
            recResBase = this.fieldDbInfo.isResource() ? (Resource)this.getRecords().elementAt(n11) : (Record)this.getRecords().elementAt(n11);
            this.file.seek(recResBase.offset);
            byArray = new byte[recResBase.size];
            this.file.read(byArray);
            byteBuffer.reset();
            byteBuffer.appendData(byArray);
            recResBase.fromBuffer(byteBuffer);
            ++n11;
        }
        this.hasToBeWritten = false;
    }

    public void readRecord(Record record) throws IOException {
        if (this.fieldDbInfo.isResource()) {
            throw new IOException("UNKNOWN ERROR!");
        }
    }

    public void setAppBlock(ByteBuffer byteBuffer) {
        this.fieldAppBlock = byteBuffer.getBuffer();
    }

    public void setDbInfo(DBInfo dBInfo) {
        this.fieldDbInfo = dBInfo;
    }

    public void setFileName(String string) {
        this.fieldFileName = string;
    }

    public void write() throws IOException {
        this.file = new BinaryFile(this.fieldFileName, "rw");
        this.writeHeader();
        byte[] byArray = null;
        Enumeration enumeration = this.getRecords().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Record) {
                byArray = ((Record)e).toBuffer().getData();
            } else if (e instanceof Resource) {
                byArray = ((Resource)e).toBuffer().getData();
            }
            this.file.write(byArray);
        }
        this.hasToBeWritten = false;
    }

    private void writeHeader() throws IOException {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendData(new byte[32]);
        byteBuffer.setString(0, this.fieldDbInfo.name);
        byteBuffer.appendShort(this.fieldDbInfo.flags);
        byteBuffer.appendShort(this.fieldDbInfo.version);
        byteBuffer.appendDate(this.fieldDbInfo.createDate.toCtagDate());
        byteBuffer.appendDate(this.fieldDbInfo.modifyDate.toCtagDate());
        byteBuffer.appendDate(this.fieldDbInfo.backupDate.toCtagDate());
        byteBuffer.appendInt(this.fieldDbInfo.modnum);
        byteBuffer.appendInt(this.getAppBlockOffset());
        byteBuffer.appendInt(this.getSortInfoOffset());
        byteBuffer.appendInt(this.fieldDbInfo.type);
        byteBuffer.appendInt(this.fieldDbInfo.creatorID);
        byteBuffer.appendInt(0);
        byteBuffer.appendInt(0);
        byteBuffer.appendShort((short)this.getNumOfRecords());
        if (byteBuffer.getLength() != 78) {
            System.out.println("PilotFile Header has wrong length !!!!");
        }
        this.file.seek(0L);
        this.file.write(byteBuffer.getData());
        byteBuffer.reset();
        int n = 78 + this.getRecInfoBlockSize() + this.getAppBlockSize() + this.getSortInfoSize() + 2;
        Enumeration enumeration = this.getRecords().elements();
        while (enumeration.hasMoreElements()) {
            RecResBase recResBase;
            if (this.getDbInfo().isResource()) {
                recResBase = (Resource)enumeration.nextElement();
                recResBase.offset = n;
                byteBuffer.appendBuffer(((Resource)recResBase).toInfoBuffer());
                n += recResBase.getSize();
                continue;
            }
            recResBase = (Record)enumeration.nextElement();
            recResBase.offset = n;
            byteBuffer.appendBuffer(((Record)recResBase).toInfoBuffer());
            n += recResBase.getSize();
        }
        byteBuffer.appendShort((short)0);
        this.file.write(byteBuffer.getData());
        if (this.fieldAppBlock != null) {
            this.file.write(this.getAppBlock().getData());
        }
        if (this.fieldSortInfo != null) {
            this.file.write(this.fieldSortInfo.getData());
        }
    }
}

