/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.pilot.RecResBase;
import ctag.types.ByteBuffer;

public class Record
extends RecResBase {
    public static final int dlpRecAttrDeleted = 128;
    public static final int dlpRecAttrDirty = 64;
    public static final int dlpRecAttrBusy = 32;
    public static final int dlpRecAttrSecret = 16;
    public static final int dlpRecAttrArchived = 8;
    public short index;
    public byte category;
    public boolean deleted;
    public boolean modified;
    public boolean busy;
    public boolean secret;
    public boolean archived;
    byte attrs;

    public Record() {
    }

    public Record(Record record) {
        super(record);
        this.index = record.index;
        this.category = record.category;
        this.setFlags(record.getFlags());
        this.buffer = record.buffer;
    }

    public Record(ByteBuffer byteBuffer) {
        this.fromBuffer(byteBuffer);
    }

    public void fromInfoBuffer(ByteBuffer byteBuffer, int n) {
        this.offset = byteBuffer.getInt(n);
        this.attrs = byteBuffer.getByte(n + 4);
        this.id = byteBuffer.getTreble(n + 5);
        this.setFlags((byte)(this.attrs & 0xF0));
        this.category = (byte)(this.attrs & 0xF);
    }

    public void fromSyncBuffer(ByteBuffer byteBuffer) {
        int n = 0;
        this.id = byteBuffer.getInt(n);
        this.index = byteBuffer.getShort(n += 4);
        this.size = byteBuffer.getShort(n += 2);
        this.setFlags(byteBuffer.getByte(n += 2));
        this.category = byteBuffer.getByte(++n);
        this.buffer.reset();
        this.buffer.appendData(byteBuffer.getData(++n));
    }

    public byte getFlags() {
        byte by = 0;
        if (this.deleted) {
            by = (byte)(by | 0x80);
        }
        if (this.modified) {
            by = (byte)(by | 0x40);
        }
        if (this.busy) {
            by = (byte)(by | 0x20);
        }
        if (this.secret) {
            by = (byte)(by | 0x10);
        }
        if (this.archived) {
            by = (byte)(by | 8);
        }
        return by;
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setFlags(byte by) {
        this.deleted = (by & 0x80) == 128;
        this.modified = (by & 0x40) == 64;
        this.busy = (by & 0x20) == 32;
        this.secret = (by & 0x10) == 16;
        this.archived = (by & 8) == 8;
    }

    protected ByteBuffer toBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = new ByteBuffer(byteBuffer.getPages());
        byteBuffer2.appendBuffer(byteBuffer);
        return byteBuffer2;
    }

    public ByteBuffer toInfoBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendInt(this.offset).appendByte(this.attrs).appendTreble(this.id);
        return byteBuffer;
    }

    public String toString() {
        return "[Record ; " + this.index + " ; " + this.size + " ; " + this.category + " ; " + this.deleted + " ; " + this.modified + " ; " + this.busy + " ; " + this.secret + " ; " + this.archived + "]";
    }

    protected ByteBuffer toSyncBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = new ByteBuffer(1);
        byteBuffer2.appendInt(this.id).appendByte(this.getFlags()).appendByte(this.category).appendBuffer(byteBuffer);
        return byteBuffer2;
    }
}

