/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot;

import ctag.pilot.PilotDate;
import ctag.pilot.Record;
import ctag.types.ByteBuffer;

public class ToDoRecord
extends Record {
    boolean indefinite;
    public PilotDate due = new PilotDate();
    public byte priority;
    public boolean completed;
    public String description;
    public String note;

    public ToDoRecord(Record record, boolean bl) {
        super(record);
        if (bl) {
            int n = 0;
            short s = this.buffer.getShort(n);
            n += 2;
            if (s != 65535) {
                this.due.fromShort(s);
                this.indefinite = false;
            } else {
                this.indefinite = true;
            }
            this.priority = this.buffer.getByte(n);
            ++n;
            if ((this.priority & 0x80) != 0) {
                this.completed = true;
                this.priority = (byte)(this.priority & 0x7F);
            } else {
                this.completed = false;
            }
            this.description = this.buffer.getString(n);
            this.note = this.buffer.getString(n += this.description.length() + 1);
            n += this.note.length() + 1;
        }
    }

    public void fromBuffer(ByteBuffer byteBuffer) {
        super.fromBuffer(byteBuffer);
        int n = 0;
        short s = this.buffer.getShort(n);
        n += 2;
        if (s != 65535) {
            this.due.fromShort(s);
            this.indefinite = false;
        } else {
            this.indefinite = true;
        }
        this.priority = this.buffer.getByte(n);
        ++n;
        if ((this.priority & 0x80) != 0) {
            this.completed = true;
            this.priority = (byte)(this.priority & 0x7F);
        } else {
            this.completed = false;
        }
        this.description = this.buffer.getString(n);
        this.note = this.buffer.getString(n += this.description.length() + 1);
        n += this.note.length() + 1;
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendShort(this.due.toShort()).appendByte(this.priority & 0x7F | (this.completed ? 128 : 0)).appendString(this.description).appendString(this.note);
        return super.toBuffer(byteBuffer);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " ; " + this.due.toString() + " ; " + this.priority + " ; " + this.completed + ";" + this.description + ";" + this.note;
    }
}

