/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.cdk;

import ctag.pilot.DBInfo;
import ctag.pilot.PilotFile;
import ctag.pilot.Record;
import ctag.pilot.Resource;
import ctag.pilot.cdk.Conduit;
import ctag.pilot.hotsync.JSync;
import ctag.pilot.hotsync.SyncException;
import ctag.types.ByteBuffer;
import java.io.File;
import java.io.IOException;

public class BackupConduit
extends Conduit {
    public BackupConduit() {
        this.setConduitName("Backup-Conduit");
        this.fieldCreatorID = 0;
        this.fieldDirectory = "backup";
        this.fieldPriority = 100;
        this.fieldSyncDirection = 0;
        this.fieldIntegrate = 0;
        this.fieldModule = "";
    }

    public boolean checkFirst() {
        File file = new File(this.getDirectory(), "");
        if (!file.isDirectory()) {
            file.mkdir();
        }
        return file.isDirectory();
    }

    public int getConduitVersion() {
        return 1;
    }

    public void run(JSync jSync, DBInfo dBInfo) {
        File file = null;
        byte by = -1;
        PilotFile pilotFile = null;
        Record record = null;
        Resource resource = null;
        if (jSync == null || dBInfo == null) {
            return;
        }
        if (!this.checkFirst()) {
            return;
        }
        try {
            jSync.openConduit(this.getConduitName());
            file = new File(this.getDirectory(), String.valueOf(dBInfo.name) + (dBInfo.isResource() ? ".prc" : ".pdb"));
            by = jSync.openDB(-128, dBInfo.name);
            pilotFile = new PilotFile(file, "rw");
            boolean bl = true;
            ByteBuffer byteBuffer = new ByteBuffer(4);
            if (jSync.readAppBlock(by, 0, 65535, byteBuffer)) {
                pilotFile.setAppBlock(byteBuffer);
            }
            pilotFile.setDbInfo(dBInfo);
            int n = jSync.readOpenRecordCount(by);
            int n2 = 0;
            while (n2 < n && bl) {
                record = new Record();
                if (dBInfo.isResource()) {
                    resource = new Resource();
                    bl = jSync.readResourceByIndex(by, n2, resource);
                    if (bl) {
                        pilotFile.append(resource);
                    }
                } else {
                    record = new Record();
                    bl = jSync.readRecordByIndex(by, n2, record);
                    if (bl) {
                        pilotFile.append(record);
                    }
                }
                ++n2;
            }
            pilotFile.write();
            pilotFile.close();
            jSync.closeDB(by);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (by != -1) {
                try {
                    jSync.closeDB(by);
                }
                catch (SyncException syncException) {}
            }
            if (pilotFile != null) {
                try {
                    pilotFile.write();
                    pilotFile.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
            return;
        }
    }
}

