/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.cdk;

import ctag.pilot.DBInfo;
import ctag.pilot.UserInfo;
import ctag.pilot.cdk.BackupConduit;
import ctag.pilot.cdk.Conduit;
import ctag.pilot.cdk.ConduitLoader;
import ctag.pilot.cdk.InstallConduit;
import ctag.pilot.cdk.SyncDialog;
import ctag.pilot.cdk.SyncSuspendListener;
import ctag.pilot.hotsync.JSync;
import ctag.pilot.hotsync.SyncEventListener;
import ctag.pilot.hotsync.SyncException;
import ctag.pilot.hotsync.UserBreakException;
import java.awt.Frame;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConduitManager
extends Thread
implements SyncEventListener,
SyncSuspendListener {
    Hashtable installedConduits = new Hashtable();
    boolean fieldDoBackup = true;
    boolean fieldDoInstall = true;
    Conduit fieldBackupConduit;
    Conduit fieldInstallConduit;
    JSync syncObj;
    SyncDialog hsDlg;
    private boolean userBreak = false;
    private boolean suspendHS = false;
    private boolean suspendable = false;
    private boolean pilotForcesAbort = false;
    private boolean dlgIsShown = false;

    public void addConduit(Conduit conduit) {
        this.installedConduits.put(String.valueOf(conduit.getCreatorID()), conduit);
    }

    public Conduit getBackupConduit() {
        return this.fieldBackupConduit;
    }

    public Conduit getConduit(int n) {
        return (Conduit)this.installedConduits.get(String.valueOf(n));
    }

    public Conduit getInstallConduit() {
        return this.fieldInstallConduit;
    }

    public static ConduitManager getInstance(JSync jSync) {
        ConduitManager conduitManager = new ConduitManager();
        conduitManager.setDoBackup(true);
        conduitManager.setDoInstall(true);
        conduitManager.setBackupConduit(new BackupConduit());
        conduitManager.setInstallConduit(new InstallConduit());
        conduitManager.syncObj = jSync;
        return conduitManager;
    }

    public static ConduitManager getInstance(JSync jSync, boolean bl, boolean bl2) {
        ConduitManager conduitManager = ConduitManager.getInstance(jSync);
        conduitManager.setDoBackup(bl);
        conduitManager.setDoInstall(bl2);
        return conduitManager;
    }

    public SyncDialog getSyncDialog() {
        if (this.hsDlg == null) {
            this.hsDlg = new SyncDialog(new Frame(), this);
        }
        return this.hsDlg;
    }

    public boolean isDoBackup() {
        return this.fieldDoBackup;
    }

    public boolean isDoInstall() {
        return this.fieldDoInstall;
    }

    public void killSyncDialog() {
        if (this.dlgIsShown) {
            this.dlgIsShown = false;
            this.getSyncDialog().dispose();
        }
    }

    public static void main(String[] stringArray) {
        try {
            ConduitManager conduitManager = new ConduitManager();
            conduitManager.readAll("Conduits");
            Enumeration enumeration = conduitManager.installedConduits.elements();
            while (enumeration.hasMoreElements()) {
                Conduit conduit = (Conduit)enumeration.nextElement();
                System.out.println(conduit.getConduitName());
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void processAbort() {
        this.pilotForcesAbort = true;
        this.processMyMessage("processAbort(): JSync says HS is aborted!");
        this.killSyncDialog();
    }

    public void processEnd() {
        this.processMyMessage("processEnd(): JSync says HS is complete!");
        this.killSyncDialog();
    }

    public void processMessage(String string) {
        this.getSyncDialog().setNewText("   JSync: " + string);
    }

    private void processMyMessage(String string) {
        this.getSyncDialog().setNewText("CM: " + string);
    }

    public synchronized void readAll(String string) {
        String[] stringArray = new File(string).list();
        ConduitLoader conduitLoader = new ConduitLoader();
        this.installedConduits = new Hashtable();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith("Conduit.class")) {
                try {
                    Object obj = conduitLoader.loadClass(String.valueOf(string) + File.separator + stringArray[n]).newInstance();
                    if (obj instanceof Conduit) {
                        this.installedConduits.put(String.valueOf(((Conduit)obj).getCreatorID()), obj);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            ++n;
        }
    }

    public void run() {
        block14: {
            this.processMyMessage("Using the following conduits :");
            Enumeration enumeration = this.installedConduits.elements();
            while (enumeration.hasMoreElements()) {
                this.processMyMessage(((Conduit)enumeration.nextElement()).getConduitName());
            }
            try {
                this.syncObj.hotSyncBegin();
            }
            catch (SyncException syncException) {
                syncException.printStackTrace();
                return;
            }
            try {
                this.processMyMessage("Reading UserrInfo...");
                UserInfo userInfo = new UserInfo();
                this.syncObj.readUserInfo(userInfo);
                this.syncObj.openConduit("");
                this.processMyMessage("Reading Databases...");
                Vector vector = this.syncObj.getDBList(-128);
                Vector<Object> vector2 = new Vector<Object>();
                if (vector == null) break block14;
                try {
                    Object object;
                    Object object2;
                    Enumeration enumeration2 = vector.elements();
                    while (enumeration2.hasMoreElements()) {
                        object2 = (DBInfo)enumeration2.nextElement();
                        this.syncSuspendable();
                        if (((DBInfo)object2).isExcludeFromSync()) continue;
                        object = this.getConduit(((DBInfo)object2).creatorID);
                        if (object == null || ((DBInfo)object2).name.equals("CitiesDB") || ((DBInfo)object2).name.equals("VendorsDB")) {
                            vector2.addElement(object2);
                            continue;
                        }
                        ((Conduit)object).addSyncEventListener(this);
                        ((Conduit)object).run(this.syncObj, (DBInfo)object2);
                    }
                    if (this.isDoBackup()) {
                        this.processMyMessage("Now doing backups...");
                        object2 = this.getBackupConduit();
                        ((Conduit)object2).addSyncEventListener(this);
                        object = vector2.elements();
                        while (object.hasMoreElements()) {
                            DBInfo dBInfo = (DBInfo)object.nextElement();
                            this.syncSuspendable();
                            ((Conduit)object2).run(this.syncObj, dBInfo);
                        }
                    }
                    if (this.isDoInstall()) {
                        this.processMyMessage("Now installing...");
                        object2 = this.getInstallConduit();
                        ((Conduit)object2).addSyncEventListener(this);
                        this.syncSuspendable();
                        ((Conduit)object2).run(this.syncObj, null);
                    }
                }
                catch (UserBreakException userBreakException) {
                    System.out.println("run() ended");
                    return;
                }
            }
            catch (SyncException syncException) {
                syncException.printStackTrace();
                return;
            }
        }
        this.processMyMessage("ConduitManager.run() -end");
        try {
            this.syncObj.hotSyncEnd();
            return;
        }
        catch (SyncException syncException) {
            syncException.printStackTrace();
            return;
        }
    }

    public void runSync() {
        this.start();
        this.dlgIsShown = true;
        this.getSyncDialog().show();
    }

    public void setBackupConduit(Conduit conduit) {
        this.fieldBackupConduit = conduit;
    }

    public void setDoBackup(boolean bl) {
        this.fieldDoBackup = bl;
    }

    public void setDoInstall(boolean bl) {
        this.fieldDoInstall = bl;
    }

    public void setInstallConduit(Conduit conduit) {
        this.fieldInstallConduit = conduit;
    }

    public boolean syncAbort() {
        this.processMyMessage("Aborting HOTSYNC ...");
        this.userBreak = true;
        this.suspendHS = false;
        try {
            this.syncObj.hotSyncContinue();
        }
        catch (SyncException syncException) {
            System.out.println("Exception in hotSyncContinue()");
            return false;
        }
        try {
            this.syncObj.hotSyncEnd();
        }
        catch (SyncException syncException) {
            System.out.println("Exception in hotSyncEnd()");
            return false;
        }
        return true;
    }

    public boolean syncContinue() {
        try {
            this.syncObj.hotSyncContinue();
            this.userBreak = false;
            this.suspendHS = false;
        }
        catch (SyncException syncException) {
            this.userBreak = false;
            this.suspendHS = false;
            return false;
        }
        return true;
    }

    public boolean syncSuspend() {
        this.userBreak = false;
        this.suspendHS = true;
        try {
            int n = 0;
            while (!this.suspendable) {
                Thread.currentThread();
                Thread.sleep(500L);
                if (++n <= 4) continue;
                this.suspendHS = false;
                return false;
            }
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.syncObj.hotSyncSuspend();
        }
        catch (SyncException syncException) {
            this.suspendHS = false;
            this.processMyMessage("Hotsync.suspend() exception.");
            return false;
        }
        return true;
    }

    private synchronized void syncSuspendable() throws UserBreakException {
        this.suspendable = true;
        if (this.pilotForcesAbort) {
            try {
                while (this.suspendHS) {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.userBreak || this.pilotForcesAbort) {
            this.suspendable = false;
            throw new UserBreakException("");
        }
        this.suspendable = false;
    }
}

