/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.hotsync;

import ctag.pilot.hotsync.JSync;
import ctag.types.ByteBuffer;

class CMPPacket {
    byte type;
    byte flags;
    int commVersion;
    int baudRate;
    public static final byte CMP_WAKEUP = 1;
    public static final byte CMP_INIT = 2;
    public static final byte CMP_ABORT = 3;

    public void dumpOut() {
        if (JSync.isDebug) {
            JSync.debugln("CMP: ");
            this.toBuffer().dumpOut();
        }
    }

    public void fromBuffer(ByteBuffer byteBuffer) {
        this.type = byteBuffer.getByte(0);
        this.flags = byteBuffer.getByte(1);
        this.commVersion = byteBuffer.getInt(2);
        this.baudRate = byteBuffer.getInt(6);
    }

    public static CMPPacket getAbortPacket() {
        CMPPacket cMPPacket = new CMPPacket();
        cMPPacket.type = (byte)3;
        cMPPacket.flags = (byte)-128;
        cMPPacket.commVersion = 0;
        cMPPacket.baudRate = 0;
        return cMPPacket;
    }

    public static CMPPacket getInitPacket(int n) {
        CMPPacket cMPPacket = new CMPPacket();
        cMPPacket.type = (byte)2;
        cMPPacket.flags = 0;
        cMPPacket.commVersion = 0;
        cMPPacket.baudRate = n;
        if (n != 9600 && n != 0) {
            cMPPacket.flags = (byte)-128;
        }
        return cMPPacket;
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.setByte(0, this.type);
        byteBuffer.setByte(1, this.flags);
        byteBuffer.setInt(2, this.commVersion);
        byteBuffer.setInt(6, this.baudRate);
        return byteBuffer;
    }
}

