/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.hotsync;

import ctag.pilot.hotsync.JSync;
import ctag.types.ByteBuffer;

class DLPPacket {
    protected byte id;
    protected byte argc;
    protected short errorCode;
    protected byte argID;
    protected int argSizeS;
    protected int argSizeB;
    protected ByteBuffer argData;

    public DLPPacket() {
    }

    public DLPPacket(byte by, byte by2, short s, byte by3, ByteBuffer byteBuffer) {
        this.id = by;
        this.argc = by2;
        this.errorCode = (this.id & 0x80) == 128 ? s : (short)0;
        this.argID = by3;
        if (byteBuffer != null) {
            if (byteBuffer.getLength() < 256) {
                this.argSizeS = byteBuffer.getLength();
                this.argSizeB = 0;
            } else {
                this.argSizeS = 0;
                this.argSizeB = byteBuffer.getLength();
                this.argID = (byte)(this.argID | 0x80);
            }
        } else {
            this.argSizeB = 0;
            this.argSizeS = 0;
        }
        this.argData = byteBuffer;
    }

    public void dumpOut() {
        if (JSync.isDebug) {
            JSync.debugln("DLP: ");
            JSync.debugln("len = " + this.toBuffer().getLength());
            this.toBuffer().dumpOut();
        }
        JSync.debug("Bodysize set= ");
        if (this.isSmallArg()) {
            JSync.debug(String.valueOf(this.argSizeS) + "small");
        } else {
            JSync.debug(String.valueOf(this.argSizeS) + "big");
        }
        JSync.debug("; real=" + this.getBody().getLength());
        JSync.debugln("");
    }

    public void fromBuffer(ByteBuffer byteBuffer) {
        int n = 0;
        this.id = byteBuffer.getByte(n);
        this.argc = byteBuffer.getByte(++n);
        ++n;
        if ((this.id & 0x80) == 128) {
            this.errorCode = byteBuffer.getShort(n);
            n += 2;
            JSync.debugln("errorCode read " + this.errorCode);
        }
        if (this.errorCode == 0 && this.argc > 0) {
            this.argID = byteBuffer.getByte(n);
            ++n;
            if ((this.argID & 0x80) == 0) {
                this.argSizeS = byteBuffer.getByte(n) & 0xFF;
                JSync.debugln("small header : bytes=" + this.argSizeS + " readpos:" + ++n);
                this.argData = byteBuffer.getBuffer(n, this.argSizeS);
            } else {
                this.argSizeB = byteBuffer.getShort(++n) & 0xFFFF;
                JSync.debugln("big header : bytes=" + this.argSizeB);
                this.argData = byteBuffer.getBuffer(n += 2, this.argSizeB);
            }
        }
        if (this.argData == null) {
            JSync.debugln("argData == null!!");
        }
    }

    public ByteBuffer getBody() {
        return this.argData;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isEndOfSynResponse() {
        return (this.id & 0xAF) == 175;
    }

    public boolean isSmallArg() {
        return (this.argID & 0x80) == 0;
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = !this.isSmallArg() ? new ByteBuffer(this.argSizeB / 2048 + 1) : new ByteBuffer(1);
        byteBuffer.appendByte(this.id).appendByte(this.argc);
        if ((this.id & 0x80) != 0) {
            byteBuffer.appendShort(this.errorCode);
        }
        byteBuffer.appendByte(this.argID);
        if (this.isSmallArg()) {
            byteBuffer.appendByte(this.argSizeS);
        } else {
            byteBuffer.appendByte((byte)0).appendShort(this.argSizeB);
        }
        byteBuffer.appendBuffer(this.argData);
        return byteBuffer;
    }
}

