/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.hotsync;

import ctag.config.Settings;
import ctag.pilot.AppInfo;
import ctag.pilot.CardInfo;
import ctag.pilot.DBInfo;
import ctag.pilot.PilotDate;
import ctag.pilot.Record;
import ctag.pilot.Resource;
import ctag.pilot.SysInfo;
import ctag.pilot.UserInfo;
import ctag.pilot.hotsync.DLPPacket;
import ctag.pilot.hotsync.Layer3;
import ctag.pilot.hotsync.PilotDeadException;
import ctag.pilot.hotsync.ProtocolStackException;
import ctag.pilot.hotsync.SyncEventListener;
import ctag.pilot.hotsync.SyncException;
import ctag.types.ByteBuffer;
import java.io.IOException;
import java.util.Vector;

public class JSync {
    public static boolean isDebug = true;
    public static final byte dlpDBListRAM = -128;
    public static final byte dlpDBListROM = 64;
    public static final int dlpEndCodeNormal = 0;
    public static final int dlpEndCodeOutOfMemory = 1;
    public static final int dlpEndCodeUserCan = 2;
    public static final int dlpEndCodeOther = 3;
    public static final byte dlpOpenRead = -128;
    public static final byte dlpOpenWrite = 64;
    public static final byte dlpOpenExclusive = 32;
    public static final byte dlpOpenSecret = 16;
    public static final byte dlpOpenReadWrite = -64;
    public static final int dlpRecAttrDeleted = 128;
    public static final int dlpRecAttrDirty = 64;
    public static final int dlpRecAttrBusy = 32;
    public static final int dlpRecAttrSecret = 16;
    public static final int dlpRecAttrArchived = 8;
    static String[] errorlist = new String[]{"No error", "General System error", "Illegal Function", "Out of memory", "Invalid parameter", "Not found", "None Open", "Already Open", "Too many Open", "Already Exists", "Cannot Open", "Record deleted", "Record busy", "Operation not supported", "-Unused-", "Read only", "Not enough space", "Limit exceeded", "Sync cancelled", "Bad arg wrapper", "Argument missing", "Bad argument size"};
    private static final int INITIAL_BAUDRATE = 9600;
    private int cardNo;
    private Layer3 protocolStack;
    private int portNo;
    private SyncEventListener fieldListener;
    private boolean activeHotSync = false;
    private boolean userBreak = false;
    private boolean suspendHS = false;
    private boolean suspendable = false;
    public int lastError;
    private long timer;
    private SysInfo ctagSysInfo;

    public JSync() {
        this.portNo = Settings.getSerialPort();
        this.protocolStack = new Layer3();
    }

    public JSync(SyncEventListener syncEventListener) {
        this.fieldListener = syncEventListener;
        this.portNo = Settings.getSerialPort();
        this.protocolStack = new Layer3();
    }

    public boolean addSyncLogEntry(String string) throws SyncException {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendString(string);
        DLPPacket dLPPacket = new DLPPacket(42, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("addSyncLogEntry()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    private void checkOpen() throws SyncException {
        if (!this.activeHotSync) {
            throw new SyncException("JSync: HS not aktiv.");
        }
    }

    public boolean cleanUpDatabase(int n) throws SyncException {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n);
        DLPPacket dLPPacket = new DLPPacket(38, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("cleanUpDatabase()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean closeDB(byte by) throws SyncException {
        this.checkOpen();
        this.fireMessage("Close Database ");
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(by);
        DLPPacket dLPPacket = new DLPPacket(25, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("closeDB()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public byte createDB(int n, int n2, short s, short s2, String string) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendInt(n).appendInt(n2).appendByte(this.cardNo).appendByte(0).appendShort(s).appendShort(s2).appendString(string);
        DLPPacket dLPPacket = new DLPPacket(24, 1, 0, 32, byteBuffer);
        byte by = 0;
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                by = dLPPacket2.getBody().getByte(0);
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("createDB()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
        return by;
    }

    public byte createDB(DBInfo dBInfo) throws SyncException {
        return this.createDB(dBInfo.creatorID, dBInfo.type, dBInfo.flags, dBInfo.version, dBInfo.name);
    }

    public static final void debug(String string) {
        if (isDebug) {
            System.out.print(string);
        }
    }

    public static final void debugln(String string) {
        if (isDebug) {
            System.out.println(string);
        }
    }

    public int deleteDB(String string) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte((byte)this.cardNo).appendByte((byte)0).appendString(string);
        DLPPacket dLPPacket = new DLPPacket(26, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            if (this.lastError != 5) {
                this.fireError("deleteDB()");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
        return 0;
    }

    public boolean deleteRecord(int n, int n2, boolean bl) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n).appendByte(bl ? 128 : 0).appendInt(n2);
        DLPPacket dLPPacket = new DLPPacket(34, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("deleteRecord()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    private void endOfSync(int n) throws SyncException {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendShort((short)0);
        DLPPacket dLPPacket = new DLPPacket(47, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            return;
        }
        catch (ProtocolStackException protocolStackException) {
            protocolStackException.printStackTrace();
            throw new SyncException("ERROR: EOS not acknoledged!");
        }
        catch (PilotDeadException pilotDeadException) {
            pilotDeadException.printStackTrace();
            this.handlePilotDead();
            throw new SyncException("ERROR: Pilot is quiet !!!");
        }
    }

    private void endOfSyncResponse() throws SyncException {
        try {
            DLPPacket dLPPacket = this.protocolStack.getPacket();
            if (!dLPPacket.isEndOfSynResponse()) {
                this.fireMessage("No END_OF_SYN_RESPONSE received.");
                this.activeHotSync = false;
                throw new SyncException("ERROR: No END_OF_SYN_RESPONSE received.");
            }
        }
        catch (PilotDeadException pilotDeadException) {
            pilotDeadException.printStackTrace();
            this.handlePilotDead();
            throw new SyncException("ERROR in JSync: ");
        }
        catch (ProtocolStackException protocolStackException) {
            protocolStackException.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean findDBInfo(int n, String string, long l, long l2, DBInfo dBInfo) throws SyncException {
        if (n < 4096) {
            int n2 = n;
            do {
                this.readDBList(-128, n2, dBInfo);
                if (!(!string.equals(dBInfo.name) || l == 0L && (long)dBInfo.type != l || l2 == 0L && (long)dBInfo.creatorID != l2)) {
                    return true;
                }
                n2 = dBInfo.index + 1;
            } while (dBInfo.more != 0);
            n2 = n;
            do {
                this.readDBList(64, n2, dBInfo);
                if (!(!string.equals(dBInfo.name) || l == 0L && (long)dBInfo.type != l || l2 == 0L && (long)dBInfo.creatorID != l2)) {
                    return true;
                }
                n2 = dBInfo.index + 1;
            } while (dBInfo.more != 0);
        }
        return false;
    }

    private void fireError(String string) {
        if (this.lastError != 0) {
            this.fireMessage(String.valueOf(string) + " : Jsync ERROR " + this.lastError + " - " + errorlist[this.lastError]);
        }
    }

    private void fireMessage(String string) {
        if (this.fieldListener != null) {
            this.fieldListener.processMessage(string);
        }
    }

    public int getCardNo() {
        return this.cardNo;
    }

    public Vector getDBList(int n) throws SyncException {
        DBInfo dBInfo;
        Vector<DBInfo> vector = new Vector<DBInfo>(10, 5);
        int n2 = 0;
        do {
            dBInfo = new DBInfo();
            this.readDBList(n, n2, dBInfo);
            vector.addElement(dBInfo);
            n2 = dBInfo.index + 1;
        } while (dBInfo.more != 0);
        return vector;
    }

    public PilotDate getSysDateTime() throws SyncException {
        PilotDate pilotDate = null;
        DLPPacket dLPPacket = new DLPPacket(19, 1, 0, 32, null);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("getSysDateTime()");
            if (dLPPacket2.getErrorCode() == 0) {
                pilotDate = new PilotDate();
                pilotDate.fromBuffer(dLPPacket2.getBody(), 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
        return pilotDate;
    }

    public long getVersion() {
        if (this.ctagSysInfo != null) {
            return this.ctagSysInfo.romVersion;
        }
        return 0L;
    }

    private void handlePilotDead() {
        this.activeHotSync = false;
        this.fieldListener.processAbort();
    }

    public void hotSyncBegin() throws SyncException {
        if (this.activeHotSync) {
            throw new SyncException("JSync: HS already running.");
        }
        this.activeHotSync = true;
        int n = 9600;
        if (!this.protocolStack.getPortIsOpen()) {
            try {
                this.fireMessage("Opening serial port...");
                this.protocolStack.portOpen(this.portNo, 9600);
            }
            catch (IOException iOException) {
                this.fireMessage("ERROR opening serial port !!");
                iOException.printStackTrace();
                this.activeHotSync = false;
                throw new SyncException("ERROR opening serial port !!");
            }
        } else {
            this.fireMessage("Serial port already opened.");
        }
        this.fireMessage("Doing handshake...");
        this.fireMessage("PRESS HOTSYNC BUTTON ON YOUR PILOT.");
        try {
            n = this.protocolStack.waitingForWakeup();
        }
        catch (PilotDeadException pilotDeadException) {
            this.handlePilotDead();
            this.fireMessage("You don\u00b4t pressed the HotSync-Button. WHY ????????");
            throw new SyncException("ERROR in JSync: no WakeUp-Packet received.");
        }
        catch (ProtocolStackException protocolStackException) {
            this.fireMessage("Pilot is sending something else????");
            this.activeHotSync = false;
            throw new SyncException("ERROR in JSync: no WakeUp-Packet received.");
        }
        this.fireMessage("GOT WAKEUP !!!");
        try {
            this.protocolStack.sendCmpInit(n);
        }
        catch (PilotDeadException pilotDeadException) {
            this.handlePilotDead();
            this.fireMessage("Pilot is very quiet !!!");
            throw new SyncException("ERROR in JSync: no WakeUp-Packet received.");
        }
        catch (ProtocolStackException protocolStackException) {
            this.fireMessage("ERROR during sendCmpInit().");
            this.activeHotSync = false;
            throw new SyncException("ERROR in JSync: CMP-Init not send correctly.");
        }
        this.fireMessage("Connection to pilot established.");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.ctagSysInfo = new SysInfo(this.readSysInfo());
        this.fireMessage("Pilot version " + this.getVersion() + ", name " + this.ctagSysInfo.name + " found !");
        this.timer = System.currentTimeMillis();
    }

    public void hotSyncContinue() throws SyncException {
        if (!this.activeHotSync) {
            this.fireMessage("HS not aktiv.");
            throw new SyncException("HS not aktiv.");
        }
        if (!this.suspendHS) {
            this.fireMessage("HS not suspended.");
            return;
        }
        this.fireMessage("Continueing HOTSYNC ...");
        this.protocolStack.stopTickles();
        this.suspendHS = false;
    }

    public void hotSyncEnd() throws SyncException {
        if (!this.activeHotSync) {
            this.fireMessage("HotSync not active.");
            return;
        }
        this.timer = System.currentTimeMillis() - this.timer;
        this.fireMessage("Estimated Time in ms: " + this.timer);
        this.fireMessage("Trying to disconnect from pilot...");
        this.fireMessage("Sending END_OF_SYN ...");
        try {
            this.endOfSync(0);
        }
        catch (SyncException syncException) {
            this.fireMessage("");
            throw new SyncException("ERROR in JSync: during EOS_SEND");
        }
        this.fireMessage("Waiting for END_OF_SYN_RESPONSE ...");
        try {
            this.endOfSyncResponse();
        }
        catch (SyncException syncException) {
            throw new SyncException("ERROR in JSync: during EOS_RES");
        }
        this.fireMessage("Pilot disconnected.");
        this.fireMessage("Trying to close serial port...");
        this.protocolStack.portClose();
        this.fireMessage("Succesfully disconnect from pilot.");
        this.activeHotSync = false;
        this.fieldListener.processEnd();
    }

    public void hotSyncSuspend() throws SyncException {
        if (!this.activeHotSync) {
            this.fireMessage("HS not aktiv.");
            throw new SyncException("HS not aktiv.");
        }
        if (this.suspendHS) {
            this.fireMessage("HS alrerady suspended.");
            return;
        }
        this.fireMessage("Suspending HOTSYNC ...");
        this.suspendHS = true;
        this.protocolStack.startTickles();
    }

    public void openConduit(String string) throws SyncException {
        this.checkOpen();
        this.fireMessage("Opening Conduit: " + string);
        DLPPacket dLPPacket = new DLPPacket(46, 1, 0, 0, null);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("openConduit()");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public byte openDB(int n, String string) throws SyncException {
        this.checkOpen();
        byte by = 0;
        this.fireMessage("Open Database: " + string);
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(this.cardNo).appendByte(n).appendString(string);
        DLPPacket dLPPacket = new DLPPacket(23, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                by = dLPPacket2.getBody().getByte(0);
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("openDB()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
        return by;
    }

    public boolean readAppBlock(int n, int n2, int n3, ByteBuffer byteBuffer) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer2 = new ByteBuffer(1);
        byteBuffer2.appendByte(n).appendByte((byte)0).appendShort(n2).appendShort(n3);
        DLPPacket dLPPacket = new DLPPacket(27, 1, 0, 32, byteBuffer2);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                byteBuffer.setBuffer(0, dLPPacket2.getBody());
                byteBuffer.cutFirst(2);
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readAppBlock()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean readAppInfo(int n, AppInfo appInfo) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n).appendByte(0).appendShort(0).appendShort(65535);
        DLPPacket dLPPacket = new DLPPacket(27, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                appInfo.fromBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readAppInfo()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public CardInfo readCardInfo(int n) throws SyncException {
        this.checkOpen();
        CardInfo cardInfo = null;
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte((byte)n).appendByte((byte)0);
        DLPPacket dLPPacket = new DLPPacket(21, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                cardInfo = new CardInfo();
                cardInfo.fromBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readCardInfo()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
        return cardInfo;
    }

    public boolean readDBList(int n, int n2, DBInfo dBInfo) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n).appendByte((byte)this.cardNo).appendShort((short)(n2 & 0xFFF));
        DLPPacket dLPPacket = new DLPPacket(22, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                dBInfo.fromBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readDBList()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean readNextModifiedRecord(int n, Record record) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n);
        DLPPacket dLPPacket = new DLPPacket(31, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                record.fromSyncBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            if (dLPPacket2.getErrorCode() != 5) {
                this.fireError("readNextModifiedRecord ()");
            }
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public int readOpenRecordCount(int n) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n);
        DLPPacket dLPPacket = new DLPPacket(43, 1, 0, 32, byteBuffer);
        int n2 = -1;
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                n2 = dLPPacket2.getBody().getShort(0) & 0xFFFF;
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readOpenRecordCount()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
        return n2;
    }

    public boolean readRecordByID(int n, int n2, Record record) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n).appendByte(0).appendInt(n2).appendShort(0).appendShort(65535);
        DLPPacket dLPPacket = new DLPPacket(32, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                record.fromSyncBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readRecordByID()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean readRecordByIndex(int n, int n2, Record record) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n).appendByte(0).appendShort(n2).appendShort(0).appendShort(65535);
        DLPPacket dLPPacket = new DLPPacket(32, 1, 0, 33, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                record.fromSyncBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            if (this.lastError != 5) {
                this.fireError("readRecordByIndex()");
            }
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean readResourceByIndex(int n, int n2, Resource resource) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n).appendByte(0).appendShort(n2).appendShort(0).appendShort(65535);
        DLPPacket dLPPacket = new DLPPacket(35, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                resource.fromSyncBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readResourceByIndex()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean readSortBlock(int n, int n2, int n3, ByteBuffer byteBuffer) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer2 = new ByteBuffer(1);
        byteBuffer2.appendByte(n).appendByte((byte)0).appendShort(n2).appendShort(n3);
        DLPPacket dLPPacket = new DLPPacket(29, 1, 0, 32, byteBuffer2);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                byteBuffer.setBuffer(0, dLPPacket2.getBody());
                byteBuffer.cutFirst(2);
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readSortBlock()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public SysInfo readSysInfo() throws SyncException {
        this.checkOpen();
        SysInfo sysInfo = null;
        this.fireMessage("Reading Sysinfo");
        try {
            DLPPacket dLPPacket = new DLPPacket(18, 1, 0, 32, null);
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                sysInfo = new SysInfo();
                sysInfo.fromBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readSysInfo()");
        }
        catch (PilotDeadException pilotDeadException) {
            pilotDeadException.printStackTrace();
            this.handlePilotDead();
            throw new SyncException("ERROR in JSync: ");
        }
        catch (ProtocolStackException protocolStackException) {
            protocolStackException.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
        return sysInfo;
    }

    public boolean readUserInfo(UserInfo userInfo) throws SyncException {
        this.checkOpen();
        this.fireMessage("Reading Userinfo");
        DLPPacket dLPPacket = new DLPPacket(16, 1, 0, 0, null);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                userInfo = new UserInfo();
                userInfo.fromBuffer(dLPPacket2.getBody());
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("readUserInfo()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (PilotDeadException pilotDeadException) {
            pilotDeadException.printStackTrace();
            this.handlePilotDead();
            throw new SyncException("ERROR in JSync: ");
        }
        catch (ProtocolStackException protocolStackException) {
            protocolStackException.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean resetDBIndex(int n) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n);
        DLPPacket dLPPacket = new DLPPacket(48, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("resetDBIndex()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean resetLastSyncPC(int n) throws SyncException {
        this.checkOpen();
        UserInfo userInfo = new UserInfo();
        if (this.readUserInfo(userInfo)) {
            userInfo.lastSyncPC = 0;
            this.writeUserInfo(userInfo);
            return true;
        }
        return false;
    }

    public boolean resetSyncFlags(int n) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n);
        DLPPacket dLPPacket = new DLPPacket(39, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("resetSyncFlags()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public void resetSystem() throws SyncException {
        if (!this.activeHotSync) {
            throw new SyncException("JSync: HS not aktiv.");
        }
        DLPPacket dLPPacket = new DLPPacket(41, 1, 0, 0, null);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public void setCardNo(int n) {
        this.cardNo = n;
    }

    public void setSyncListener(SyncEventListener syncEventListener) {
        this.fieldListener = syncEventListener;
    }

    public boolean setSysDateTime(PilotDate pilotDate) throws SyncException {
        this.checkOpen();
        DLPPacket dLPPacket = new DLPPacket(20, 1, 0, 32, pilotDate.toBuffer());
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("setSysDateTime()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean writeAppBlock(int n, ByteBuffer byteBuffer) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer2 = new ByteBuffer(1);
        byteBuffer2.appendByte(n).appendByte(0).appendShort(byteBuffer.getLength()).appendBuffer(byteBuffer);
        DLPPacket dLPPacket = new DLPPacket(28, 1, 0, 32, byteBuffer2);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("writeAppBlock/Info()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean writeAppInfo(int n, AppInfo appInfo) throws SyncException {
        return this.writeAppBlock(n, appInfo.toBuffer());
    }

    public int writeRecord(int n, Record record) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n).appendByte(0).appendInt(record.getId()).appendByte(record.getFlags()).appendByte(record.category).appendBuffer(record.toBuffer());
        DLPPacket dLPPacket = new DLPPacket(33, 1, 0, 32, byteBuffer);
        int n2 = -1;
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            if (dLPPacket2.getErrorCode() == 0) {
                n2 = dLPPacket2.getBody().getInt(0);
            }
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("writeRecord()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
        return n2;
    }

    public boolean writeResource(int n, Resource resource) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(n).appendByte(0).appendInt(resource.getType()).appendShort(resource.getId()).appendShort(resource.getSize()).appendBuffer(resource.toBuffer());
        DLPPacket dLPPacket = new DLPPacket(36, 1, 0, 32, byteBuffer);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("writeResource()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean writeSortBlock(int n, ByteBuffer byteBuffer) throws SyncException {
        this.checkOpen();
        ByteBuffer byteBuffer2 = new ByteBuffer(1);
        byteBuffer2.appendByte(n).appendByte(0).appendShort(byteBuffer.getLength()).appendBuffer(byteBuffer);
        DLPPacket dLPPacket = new DLPPacket(30, 1, 0, 32, byteBuffer2);
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("writeSortBlock()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }

    public boolean writeUserInfo(UserInfo userInfo) throws SyncException {
        this.checkOpen();
        DLPPacket dLPPacket = new DLPPacket(17, 1, 0, 32, userInfo.toBuffer());
        try {
            this.protocolStack.sendPacket(dLPPacket);
            DLPPacket dLPPacket2 = this.protocolStack.getPacket();
            this.lastError = dLPPacket2.getErrorCode();
            this.fireError("writeUserInfo()");
            return dLPPacket2.getErrorCode() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SyncException("ERROR in JSync: ");
        }
    }
}

