/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.hotsync;

import ctag.comm.BaseSerialPort;
import ctag.comm.SimpleSerialPort;
import ctag.comm.SimpleSerialPortx;
import ctag.config.Settings;
import ctag.pilot.hotsync.JSync;
import ctag.pilot.hotsync.PilotDeadException;
import ctag.pilot.hotsync.SLPPacket;
import ctag.pilot.hotsync.TimeOutException;
import ctag.types.ByteBuffer;
import java.io.IOException;

class Layer1 {
    BaseSerialPort com_port;
    ByteBuffer byteB = new ByteBuffer(2);

    public SLPPacket getPacket() throws TimeOutException {
        int n = -1;
        SLPPacket sLPPacket = null;
        JSync.debug("Reading new SLP " + this.byteB.getLength());
        while (sLPPacket == null) {
            this.portRead(10);
            JSync.debug("->" + this.byteB.getLength() + " ... ");
            n = this.byteB.findFirst(SLPPacket.PREAMBLE);
            if (n == -1) {
                JSync.debugln("No PREAMBLE found!");
                if (this.byteB.getLength() <= 2) continue;
                this.byteB = this.byteB.cutFirst(this.byteB.getLength() - 2);
                continue;
            }
            this.byteB = this.byteB.cutFirst(n);
            this.byteB.clearBytes(0, 3);
            JSync.debug("Header ");
            this.portRead(10);
            JSync.debug(" ... ");
            sLPPacket = new SLPPacket();
            sLPPacket.headerFromBuffer(this.byteB, 0);
            byte by = sLPPacket.calcHeaderCheckSum();
            if (by != sLPPacket.checkSum) {
                sLPPacket = null;
                continue;
            }
            JSync.debug("Body ");
            this.portRead(10 + sLPPacket.getBodySize() + 2);
            JSync.debug(" ... ");
            sLPPacket.bodyAndCrcFromBuffer(this.byteB, 10);
            JSync.debugln("complete!");
            short s = sLPPacket.calcCrcCheckSum();
            if (s != sLPPacket.crcCheckSum) {
                sLPPacket.dumpOut();
                sLPPacket = null;
                JSync.debugln("Wrong CRC!");
                continue;
            }
            this.byteB = this.byteB.cutFirst(10 + sLPPacket.getBodySize() + 2);
            if (!sLPPacket.isLoopBack()) continue;
            JSync.debugln("LoopBack -> Ignoring !!");
            sLPPacket = null;
        }
        JSync.debug("Received ");
        sLPPacket.dumpOut();
        return sLPPacket;
    }

    public void portChangeBaud(int n) throws PilotDeadException {
        try {
            this.com_port.changeBaud(n);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PilotDeadException("portChangeBaud.");
        }
    }

    public void portClose() {
        try {
            this.com_port.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public void portOpen(int n, int n2) throws IOException {
        this.com_port = Settings.getSerialPortType() == 0 ? new SimpleSerialPort(n, n2) : new SimpleSerialPortx(n, n2);
        if (this.com_port == null) {
            throw new IOException("null");
        }
    }

    private void portRead(int n) throws TimeOutException {
        int n2 = this.byteB.getLength();
        int n3 = 400;
        while (n3 > 0 && n2 < n) {
            try {
                if (this.com_port.dataAvailable() > 0) {
                    while (this.com_port.dataAvailable() > 0) {
                        this.byteB.appendByte(this.com_port.readByte());
                        ++n2;
                    }
                    continue;
                }
                --n3;
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (n2 < n) {
            throw new TimeOutException("[Layer1.portRead()]Not enough data from Buffer!");
        }
    }

    private void portWrite(byte by) throws PilotDeadException {
        try {
            this.com_port.writeByte(by);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PilotDeadException("portWrite.");
        }
    }

    private void portWrite(ByteBuffer byteBuffer) throws PilotDeadException {
        try {
            this.com_port.writeData(byteBuffer.getData());
            this.com_port.flush();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PilotDeadException("portWrite.");
        }
    }

    public void sendPacket(SLPPacket sLPPacket) throws PilotDeadException {
        JSync.debug("Send ");
        sLPPacket.dumpOut();
        this.portWrite(sLPPacket.toBuffer());
    }
}

