/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.hotsync;

import ctag.pilot.hotsync.JSync;
import ctag.pilot.hotsync.Layer1;
import ctag.pilot.hotsync.PADPPacket;
import ctag.pilot.hotsync.PilotDeadException;
import ctag.pilot.hotsync.ProtocolStackException;
import ctag.pilot.hotsync.SLPPacket;
import ctag.pilot.hotsync.TimeOutException;
import java.io.IOException;

class Layer2 {
    private Layer1 layer1 = new Layer1();
    static final int SEND_RETRIES = 5;

    private boolean getAcknowledge(PADPPacket pADPPacket) throws PilotDeadException {
        PADPPacket pADPPacket2 = new PADPPacket();
        do {
            SLPPacket sLPPacket;
            try {
                sLPPacket = this.layer1.getPacket();
            }
            catch (TimeOutException timeOutException) {
                timeOutException.printStackTrace();
                throw new PilotDeadException("Pilot sendet kein Acknoledge.");
            }
            pADPPacket2.fromBuffer(sLPPacket.getBody());
        } while (pADPPacket2.isTickle());
        if (pADPPacket2.isAcknoledge() && pADPPacket2.flags == pADPPacket.flags && pADPPacket2.sizeOrOffset == pADPPacket.sizeOrOffset) {
            JSync.debugln("- Acknoledged! ");
            return true;
        }
        JSync.isDebug = true;
        JSync.debugln("Acknoledge-Packet: ");
        pADPPacket2.dumpOut();
        JSync.debugln("Packet: ");
        pADPPacket.dumpOut();
        JSync.isDebug = false;
        return false;
    }

    public PADPPacket getPacket() throws PilotDeadException {
        PADPPacket pADPPacket = new PADPPacket();
        SLPPacket sLPPacket = null;
        do {
            try {
                sLPPacket = this.layer1.getPacket();
            }
            catch (TimeOutException timeOutException) {
                throw new PilotDeadException("layer2.getPacket(): Timeout in Layer1");
            }
            JSync.debugln("layer2.getPacket():SLPPacket received!");
            pADPPacket.fromBuffer(sLPPacket.getBody());
            JSync.debugln("SLP Packet -> PADP Packet (transformed) ");
        } while (pADPPacket.isTickle());
        if (!pADPPacket.isAcknoledge()) {
            JSync.debugln("");
            JSync.debugln("Sending a Acknoledge : ");
            this.sendAcknowledge(pADPPacket, sLPPacket.transId);
        }
        return pADPPacket;
    }

    public void portChangeBaud(int n) throws PilotDeadException {
        this.layer1.portChangeBaud(n);
    }

    public void portClose() {
        this.layer1.portClose();
    }

    public void portOpen(int n, int n2) throws IOException {
        this.layer1.portOpen(n, n2);
    }

    private void sendAcknowledge(PADPPacket pADPPacket, int n) throws PilotDeadException {
        SLPPacket sLPPacket = new SLPPacket();
        PADPPacket pADPPacket2 = pADPPacket.getAcknowledge();
        sLPPacket.setBody(pADPPacket2.toBuffer());
        sLPPacket.transId = n;
        sLPPacket.checkSum = sLPPacket.calcHeaderCheckSum();
        sLPPacket.crcCheckSum = sLPPacket.calcCrcCheckSum();
        this.layer1.sendPacket(sLPPacket);
        JSync.debugln("Acknoledge send!");
    }

    public void sendPacket(PADPPacket pADPPacket) throws ProtocolStackException, PilotDeadException {
        JSync.debug("PADP Packet -> SLPPacket ");
        SLPPacket.nextTransID();
        SLPPacket sLPPacket = new SLPPacket();
        sLPPacket.setBody(pADPPacket.toBuffer());
        sLPPacket.checkSum = sLPPacket.calcHeaderCheckSum();
        sLPPacket.crcCheckSum = sLPPacket.calcCrcCheckSum();
        JSync.debugln("(transformed)");
        boolean bl = false;
        int n = 5;
        JSync.debugln(" Sending SLP-Packet and waiting for Acknowledge!");
        while (!bl && n > 0) {
            this.layer1.sendPacket(sLPPacket);
            bl = this.getAcknowledge(pADPPacket);
            --n;
        }
        if (!bl) {
            throw new ProtocolStackException("Layer2.sendPacket() No Acknowledge on packet!");
        }
    }

    public void sendTickle() throws PilotDeadException {
        PADPPacket pADPPacket = new PADPPacket();
        pADPPacket.type = (byte)4;
        SLPPacket sLPPacket = new SLPPacket();
        sLPPacket.setBody(pADPPacket.toBuffer());
        sLPPacket.checkSum = sLPPacket.calcHeaderCheckSum();
        sLPPacket.crcCheckSum = sLPPacket.calcCrcCheckSum();
        JSync.debugln("Sending PADP-Tickle.");
        this.layer1.sendPacket(sLPPacket);
    }
}

