/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.hotsync;

import ctag.pilot.hotsync.CMPPacket;
import ctag.pilot.hotsync.DLPPacket;
import ctag.pilot.hotsync.JSync;
import ctag.pilot.hotsync.Layer2;
import ctag.pilot.hotsync.PADPPacket;
import ctag.pilot.hotsync.PilotDeadException;
import ctag.pilot.hotsync.ProtocolStackException;
import ctag.pilot.hotsync.TickleSender;
import ctag.types.ByteBuffer;
import java.io.IOException;

class Layer3 {
    private Layer2 layer2 = new Layer2();
    private boolean portIsOpen = false;
    private TickleSender ts;

    public DLPPacket getPacket() throws PilotDeadException, ProtocolStackException {
        PADPPacket pADPPacket = null;
        DLPPacket dLPPacket = new DLPPacket();
        pADPPacket = this.layer2.getPacket();
        if (pADPPacket.containsCmpPacket()) {
            JSync.debugln("PADP Packet contains a CMPPacket!");
            throw new ProtocolStackException("Receiving a CMP-Packet, but a DLP-Packet was expected!");
        }
        if (pADPPacket.flags == -64) {
            JSync.debugln("PADP Packet contains a whole DLPPacket!");
            ByteBuffer byteBuffer = pADPPacket.getBody();
            if (byteBuffer == null) {
                JSync.debug("BB ist null !!!");
            }
            dLPPacket.fromBuffer(byteBuffer);
        } else {
            JSync.debugln("PADP Packet contains a DLPPacket-Fragment!");
            int n = pADPPacket.sizeOrOffset / 1024 + 1;
            boolean[] blArray = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                blArray[n2] = false;
                ++n2;
            }
            ByteBuffer byteBuffer = new ByteBuffer(pADPPacket.sizeOrOffset / 2048 + 1);
            byteBuffer.setBuffer(0, pADPPacket.getBody());
            blArray[0] = true;
            do {
                pADPPacket = this.layer2.getPacket();
                if (pADPPacket.flags != 0) continue;
                byteBuffer.setBuffer(pADPPacket.sizeOrOffset, pADPPacket.getBody());
                blArray[pADPPacket.sizeOrOffset / 1024] = true;
            } while (pADPPacket.flags == 0);
            byteBuffer.setBuffer(pADPPacket.sizeOrOffset, pADPPacket.getBody());
            blArray[pADPPacket.sizeOrOffset / 1024] = true;
            int n3 = 0;
            while (n3 < n) {
                if (!blArray[n3]) {
                    throw new ProtocolStackException("One or more DLP-Packet-Fragments not received!");
                }
                ++n3;
            }
            dLPPacket.fromBuffer(byteBuffer);
        }
        return dLPPacket;
    }

    public boolean getPortIsOpen() {
        return this.portIsOpen;
    }

    public void portClose() {
        if (this.portIsOpen) {
            this.layer2.portClose();
        }
        this.portIsOpen = false;
    }

    public void portOpen(int n, int n2) throws IOException {
        if (this.portIsOpen) {
            return;
        }
        this.layer2.portOpen(n, n2);
        this.portIsOpen = true;
    }

    public void sendCmpInit(int n) throws PilotDeadException, ProtocolStackException {
        CMPPacket cMPPacket = new CMPPacket();
        PADPPacket pADPPacket = new PADPPacket();
        JSync.debugln("Sending CMP Init (changes baud) ...");
        cMPPacket = CMPPacket.getInitPacket(n);
        pADPPacket = pADPPacket.fromCMPPacket(cMPPacket);
        try {
            this.layer2.sendPacket(pADPPacket);
            this.layer2.portChangeBaud(n);
        }
        catch (PilotDeadException pilotDeadException) {
            pilotDeadException.printStackTrace();
            throw new ProtocolStackException("ERROR during sending CMP-Init.");
        }
        JSync.debugln("HotSync-Handshake: complete!");
    }

    public void sendPacket(DLPPacket dLPPacket) throws PilotDeadException, ProtocolStackException {
        if (!this.portIsOpen) {
            throw new ProtocolStackException("No connection to Pilot !!!");
        }
        PADPPacket pADPPacket = new PADPPacket();
        ByteBuffer byteBuffer = dLPPacket.toBuffer();
        if (byteBuffer.getLength() <= 1024) {
            JSync.debugln("PADP Packet fits in one SLP Packet");
            pADPPacket.setBody(byteBuffer);
            this.layer2.sendPacket(pADPPacket);
            return;
        }
        JSync.debug("PADP Packet doesn\u00b4t fit in one SLP Packet -> Building Fragments: ");
        int n = 1024;
        int n2 = 0;
        pADPPacket.flags = (byte)-128;
        pADPPacket.setBody(byteBuffer.getBuffer(n2, n));
        pADPPacket.sizeOrOffset = (short)(byteBuffer.getLength() & 0xFFFF);
        JSync.debug("*");
        this.layer2.sendPacket(pADPPacket);
        n2 += n;
        pADPPacket.flags = 0;
        while (n2 < byteBuffer.getLength()) {
            if (n2 + n > byteBuffer.getLength()) {
                n = byteBuffer.getLength() - n2;
                pADPPacket.flags = (byte)64;
                JSync.debug("last Fragment" + n2);
            }
            pADPPacket.setBody(byteBuffer.getBuffer(n2, n));
            pADPPacket.sizeOrOffset = n2;
            n2 += n;
            JSync.debug("*");
            this.layer2.sendPacket(pADPPacket);
        }
    }

    public void startTickles() {
        if (!this.portIsOpen || this.ts != null) {
            return;
        }
        this.ts = new TickleSender(this.layer2);
        this.ts.start();
        JSync.debugln("After l3.stopTickles: ts.start");
    }

    public void stopTickles() {
        if (!this.ts.isAlive()) {
            return;
        }
        this.ts.requestStop();
        try {
            while (this.ts.isAlive()) {
                Thread.currentThread();
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {}
        this.ts = null;
        JSync.debugln("After l3.stopTickles");
    }

    public int waitingForWakeup() throws ProtocolStackException, PilotDeadException {
        PADPPacket pADPPacket = null;
        CMPPacket cMPPacket = new CMPPacket();
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        JSync.debugln("Waiting for WAKEUP ...");
        while (bl) {
            try {
                pADPPacket = this.layer2.getPacket();
                if (pADPPacket.containsCmpPacket()) {
                    cMPPacket.fromBuffer(pADPPacket.getBody());
                    if (cMPPacket.type != 1) continue;
                    bl = false;
                    continue;
                }
                if (++n2 < 5) continue;
                JSync.debugln("ERROR during waitingForWakeup().");
                throw new ProtocolStackException("5 ERRORs during waitingForWakeup().");
            }
            catch (PilotDeadException pilotDeadException) {
                if (++n <= 5) continue;
                throw new PilotDeadException("PilotDead: 6 times during Wakeup.");
            }
        }
        return cMPPacket.baudRate & 0xFFFF;
    }
}

