/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.hotsync;

import ctag.pilot.hotsync.CMPPacket;
import ctag.pilot.hotsync.JSync;
import ctag.types.ByteBuffer;

class PADPPacket {
    public static final int HEADER_SIZEINBYTES = 4;
    byte type = 1;
    byte flags = (byte)-64;
    public int sizeOrOffset;
    public static final byte PAD_DATA = 1;
    public static final byte PAD_ACK = 2;
    public static final byte PAD_TICKLE = 4;
    public static final byte PAD_ABORT = 8;
    public static final byte PAD_HDR_FLAG_FIRST = -128;
    public static final byte PAD_HDR_FLAG_LAST = 64;
    ByteBuffer bodyPacket;

    public boolean containsCmpPacket() {
        if (this.bodyPacket == null) {
            return false;
        }
        return (short)(this.bodyPacket.getByte(0) & 0xFF) < 16;
    }

    public void dumpOut() {
        if (JSync.isDebug) {
            JSync.debugln("PADP: ");
            this.toBuffer().dumpOut();
        }
    }

    public void fromBuffer(ByteBuffer byteBuffer) {
        this.type = byteBuffer.getByte(0);
        this.flags = byteBuffer.getByte(1);
        this.sizeOrOffset = byteBuffer.getShort(2) & 0xFFFF;
        if (!this.isAcknoledge()) {
            this.bodyPacket = byteBuffer.getBuffer(4, byteBuffer.getLength() - 4);
            return;
        }
        this.bodyPacket = null;
    }

    public PADPPacket fromCMPPacket(CMPPacket cMPPacket) {
        this.type = 1;
        this.flags = (byte)-64;
        this.sizeOrOffset = 10;
        this.bodyPacket = cMPPacket.toBuffer();
        return this;
    }

    public static PADPPacket getAbortPacket() {
        PADPPacket pADPPacket = new PADPPacket();
        pADPPacket.type = (byte)8;
        pADPPacket.flags = (byte)-64;
        pADPPacket.sizeOrOffset = 10;
        return pADPPacket;
    }

    public PADPPacket getAcknowledge() {
        PADPPacket pADPPacket = new PADPPacket();
        pADPPacket.type = (byte)2;
        pADPPacket.flags = this.flags;
        pADPPacket.sizeOrOffset = this.sizeOrOffset;
        pADPPacket.bodyPacket = null;
        return pADPPacket;
    }

    public ByteBuffer getBody() {
        return this.bodyPacket;
    }

    public boolean isAcknoledge() {
        return this.type == 2;
    }

    public boolean isTickle() {
        return this.type == 4;
    }

    public void setBody(ByteBuffer byteBuffer) {
        this.bodyPacket = byteBuffer;
        this.sizeOrOffset = byteBuffer.getLength();
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendByte(this.type).appendByte(this.flags).appendShort(this.sizeOrOffset);
        if (this.bodyPacket != null) {
            byteBuffer.appendBuffer(this.bodyPacket);
        }
        return byteBuffer;
    }

    PADPPacket() {
    }
}

