/*
 * Decompiled with CFR 0.152.
 */
package ctag.pilot.hotsync;

import ctag.pilot.hotsync.JSync;
import ctag.types.ByteBuffer;

class SLPPacket {
    public static final int HEADER_SIZEINBYTES = 10;
    public static final byte PREAMBLE1 = -66;
    public static final byte PREAMBLE2 = -17;
    public static final byte PREAMBLE3 = -19;
    public static final byte[] PREAMBLE = new byte[]{-66, -17, -19};
    byte destPort = (byte)3;
    byte srcPort = (byte)3;
    byte type = (byte)2;
    short bodySize = 0;
    int transId = cTransId;
    byte checkSum = 0;
    public static final byte SLP_PKT_TYPE_SYSTEM = 0;
    public static final byte SLP_PKT_TYPE_PAD = 2;
    public static final byte SLP_PKT_TYPE_LOOPBACKTEST = 3;
    ByteBuffer bodyPacket;
    short crcCheckSum;
    private static int cTransId = 1;
    private static byte stDestPort = (byte)3;
    private static byte stSrcPort = (byte)3;
    private static boolean stPortIsSet;

    public void bodyAndCrcFromBuffer(ByteBuffer byteBuffer, int n) {
        this.bodyPacket = byteBuffer.getBuffer(n, this.getBodySize());
        this.crcCheckSum = byteBuffer.getShort(n + this.getBodySize());
    }

    public short calcCrcCheckSum() {
        ByteBuffer byteBuffer = this.toBuffer();
        return byteBuffer.crc16(0, byteBuffer.getLength() - 2);
    }

    public byte calcHeaderCheckSum() {
        return (byte)(666 + (this.destPort & 0xFF) + (this.srcPort & 0xFF) + (this.type & 0xFF) + (this.bodySize & 0xFF) + (this.bodySize >> 8 & 0xFF) + (this.transId & 0xFF));
    }

    public void dumpOut() {
        if (JSync.isDebug) {
            JSync.debugln("SLP: ");
            this.toBuffer().dumpOut();
        }
    }

    public ByteBuffer getBody() {
        return this.bodyPacket;
    }

    public int getBodySize() {
        return this.bodySize & 0xFFFF;
    }

    public void headerFromBuffer(ByteBuffer byteBuffer, int n) {
        this.destPort = byteBuffer.getByte(n + 3);
        this.srcPort = byteBuffer.getByte(n + 4);
        this.type = byteBuffer.getByte(n + 5);
        this.bodySize = byteBuffer.getShort(n + 6);
        this.transId = byteBuffer.getByte(n + 8) & 0xFF;
        this.checkSum = byteBuffer.getByte(n + 9);
        if (!stPortIsSet) {
            stDestPort = this.destPort;
            stSrcPort = this.srcPort;
            stPortIsSet = true;
        }
    }

    public boolean isLoopBack() {
        return this.getBodySize() == 0 || this.type == 3;
    }

    public static void nextTransID() {
        if (++cTransId >= 255) {
            cTransId = 1;
        }
    }

    public void setBody(ByteBuffer byteBuffer) {
        this.bodyPacket = byteBuffer;
        this.bodySize = (short)byteBuffer.getLength();
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendData(PREAMBLE);
        byteBuffer.appendByte(this.destPort).appendByte(this.srcPort).appendByte(this.type).appendShort(this.bodySize).appendByte(this.transId).appendByte(this.checkSum).appendBuffer(this.bodyPacket).appendShort(this.crcCheckSum);
        return byteBuffer;
    }
}

