/*
 * Decompiled with CFR 0.152.
 */
package ctag.comm;

import ctag.config.Settings;
import java.io.IOException;

public abstract class BaseSerialPort {
    protected String name;
    protected int port;
    protected long handle;
    protected int baud = 9600;
    protected String protocol = "N81";
    protected boolean isOpen = false;
    public static boolean isAvailable = true;
    public static final int B9600 = 9600;
    public static final int B19200 = 19200;
    public static final int B37800 = 37800;

    public BaseSerialPort(int n) throws IOException {
        this.baud = n;
        this.port = Settings.getSerialPort();
        this.name = new String("port" + this.port);
        this.isOpen = false;
        this.open();
        this.isOpen = true;
    }

    public BaseSerialPort(int n, int n2) throws IOException {
        this.baud = n2;
        this.port = n;
        this.name = new String("port" + this.port);
        this.isOpen = false;
        this.open();
        this.isOpen = true;
    }

    public abstract void changeBaud(int var1) throws IOException;

    private void checkIfOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Port not open !!!" + this.port);
        }
    }

    public abstract void close() throws IOException;

    public abstract int dataAvailable() throws IOException;

    public abstract void flush() throws IOException;

    public String getName() {
        return this.name;
    }

    public int getPortNum() {
        return this.port;
    }

    public String getVersion() {
        return "Class: 0.1";
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public abstract void open() throws IOException;

    public abstract byte readByte() throws IOException;

    public void readData(byte[] byArray) throws IOException {
        int n = 0;
        while (this.dataAvailable() > 0) {
            byArray[n] = this.readByte();
            ++n;
        }
    }

    public void setBaud(int n) {
        this.baud = n;
    }

    public void setName(String string) {
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String toString() {
        return " [ CtagSerialPort " + this.name + " ]";
    }

    public void writeByte(byte by) throws IOException {
        this.checkIfOpen();
        byte[] byArray = new byte[]{by};
        this.writeData(byArray);
    }

    public abstract void writeData(byte[] var1) throws IOException;

    public void writeString(String string) throws IOException {
        this.writeData(string.getBytes());
    }
}

