/*
 * Decompiled with CFR 0.152.
 */
package ctag.comm;

import ctag.comm.BaseSerialPort;
import ctag.comm.SimpleSerialPortInputStream;
import ctag.comm.SimpleSerialPortOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SimpleSerialPort
extends BaseSerialPort {
    public SimpleSerialPort(int n) throws IOException {
        super(n);
    }

    public SimpleSerialPort(int n, int n2) throws IOException {
        super(n, n2);
    }

    public void changeBaud(int n) throws IOException {
        this.checkIfOpen();
        this.NchangeBaud(n);
        this.baud = n;
    }

    private void checkIfOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Port not open !!!" + this.port);
        }
    }

    public void close() throws IOException {
        this.Nclose();
    }

    public int dataAvailable() throws IOException {
        int n = this.NdataAvailable();
        if (n == -1) {
            throw new IOException("[dataAvailable()] Error reading port " + this.port);
        }
        return n;
    }

    public void flush() throws IOException {
        while (this.NdataWaiting() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public InputStream getInputStream() throws IOException {
        return new SimpleSerialPortInputStream(this);
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        return new SimpleSerialPortOutputStream(this);
    }

    public int getPortNum() {
        return this.port;
    }

    public String getVersion() {
        return "Class: 0.1; DLL: " + SimpleSerialPort.NgetVersion();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private native void NchangeBaud(int var1) throws IOException;

    private native void Nclose() throws IOException;

    private native int NdataAvailable() throws IOException;

    private native int NdataWaiting() throws IOException;

    private static native String NgetVersion();

    private native void Nopen(int var1, int var2, String var3) throws IOException;

    private native byte[] NreadAvailableBytes() throws IOException;

    private native byte NreadByte() throws IOException;

    private native void NwriteData(byte[] var1) throws IOException;

    public void open() throws IOException {
        this.Nopen(this.port, this.baud, this.protocol);
        this.isOpen = true;
    }

    public byte readByte() throws IOException {
        this.checkIfOpen();
        return this.NreadByte();
    }

    public void readData(byte[] byArray) throws IOException {
        byArray = new byte[this.dataAvailable()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = this.readByte();
            ++n;
        }
    }

    public void readData(byte[] byArray, int n, int n2) throws IOException {
        byArray = new byte[this.dataAvailable()];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = this.readByte();
            ++n3;
        }
    }

    public void setBaud(int n) {
        this.baud = n;
    }

    public void setName(String string) {
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String toString() {
        return " [ CtagSerialPort " + this.name + " ]";
    }

    public void writeByte(byte by) throws IOException {
        this.checkIfOpen();
        byte[] byArray = new byte[]{by};
        this.writeData(byArray);
    }

    public void writeData(byte[] byArray) throws IOException {
        this.checkIfOpen();
        this.NwriteData(byArray);
    }

    public void writeString(String string) throws IOException {
        this.writeData(string.getBytes());
    }

    static {
        try {
            System.loadLibrary("ctagSSP");
            BaseSerialPort.isAvailable = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }
}

