/*
 * Decompiled with CFR 0.152.
 */
package ctag.comm;

import ctag.comm.BaseSerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class SimpleSerialPortx
extends BaseSerialPort {
    SerialPort serialPort;
    OutputStream outputStream;
    InputStream inputStream;

    public SimpleSerialPortx(int n) throws IOException {
        super(n);
    }

    public SimpleSerialPortx(int n, int n2) throws IOException {
        super(n, n2);
    }

    public void changeBaud(int n) throws IOException {
        this.checkIfOpen();
        try {
            this.serialPort.setSerialPortParams(n, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {}
        this.baud = n;
    }

    private void checkIfOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Port not open !!!" + this.port);
        }
    }

    public void close() throws IOException {
        this.inputStream.close();
        this.outputStream.close();
    }

    public int dataAvailable() throws IOException {
        return this.inputStream.available();
    }

    public void flush() throws IOException {
    }

    public String getName() {
        return this.name;
    }

    public int getPortNum() {
        return this.port;
    }

    public String getVersion() {
        return "Class: 0.1";
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void open() throws IOException {
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1 || !commPortIdentifier.getName().equals("COM" + (this.port + 1))) continue;
            try {
                this.serialPort = (SerialPort)commPortIdentifier.openPort("SampleWriteApp", 2000);
            }
            catch (PortInUseException portInUseException) {
                throw new IOException("Port not open !!!" + this.port);
            }
            this.outputStream = this.serialPort.getOutputStream();
            this.inputStream = this.serialPort.getInputStream();
            try {
                this.serialPort.setSerialPortParams(this.baud, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                throw new IOException("Port not open !!!" + this.port);
            }
            this.isOpen = true;
            return;
        }
        throw new IOException("Port not found !!!" + this.port);
    }

    public byte readByte() throws IOException {
        this.checkIfOpen();
        return (byte)(this.inputStream.read() & 0xFF);
    }

    public void readData(byte[] byArray) throws IOException {
        int n = 0;
        while (this.dataAvailable() > 0) {
            byArray[n] = this.readByte();
            ++n;
        }
    }

    public void setBaud(int n) {
        this.baud = n;
    }

    public void setName(String string) {
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String toString() {
        return " [ CtagSerialPort " + this.name + " ]";
    }

    public void writeByte(byte by) throws IOException {
        this.checkIfOpen();
        byte[] byArray = new byte[]{by};
        this.writeData(byArray);
    }

    public void writeData(byte[] byArray) throws IOException {
        this.checkIfOpen();
        this.outputStream.write(byArray);
    }

    public void writeString(String string) throws IOException {
        this.writeData(string.getBytes());
    }
}

