/*
 * Decompiled with CFR 0.152.
 */
package ctag.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class Settings {
    private static ResourceBundle defaultResourceBundle;
    private static ResourceBundle ctagResourceBundle;
    private static Locale ctagLocale;
    private static TimeZone ctagTimeZone;
    private static boolean hasToBeSaved;
    private static int serialPort;
    public static final int CTAG_SERIAL_PORT = 0;
    public static final int SUNX_SERIAL_PORT = 1;
    private static int serialPortType;

    public Settings() {
        Settings.load();
    }

    public static String getCtagNLSString(String string) {
        try {
            return ctagResourceBundle.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static ResourceBundle getCtagResourceBundle() {
        if (ctagResourceBundle == null) {
            ctagResourceBundle = ResourceBundle.getBundle("ctag.bundles.CtagBundle");
        }
        return ctagResourceBundle;
    }

    public static ResourceBundle getDefaultResourceBundle() {
        return defaultResourceBundle;
    }

    public static Locale getLocale() {
        return ctagLocale;
    }

    public static String getNLSString(String string) {
        try {
            return Settings.getDefaultResourceBundle().getString(string);
        }
        catch (Exception exception) {
            try {
                return Settings.getCtagNLSString(string);
            }
            catch (Exception exception2) {
                System.out.println("\t{\"" + string + "\",\t\t\"" + string + "\"},");
                return string;
            }
        }
    }

    public static int getSerialPort() {
        return serialPort;
    }

    public static int getSerialPortType() {
        return serialPortType;
    }

    public static TimeZone getTimeZone() {
        return ctagTimeZone;
    }

    public static void load() {
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(new File(System.getProperty("user.home"), ".CTAG.INI"));
            properties.load(fileInputStream);
            fileInputStream.close();
            Settings.setLocale(new Locale(properties.getProperty("Locale_language", Locale.getDefault().getLanguage()), properties.getProperty("Locale_country", Locale.getDefault().getCountry())));
            Settings.setTimeZone(TimeZone.getTimeZone(properties.getProperty("timezone", TimeZone.getDefault().getID())));
            Settings.setSerialPort(Integer.parseInt(properties.getProperty("serialPort", String.valueOf(serialPort))));
            Settings.setSerialPortType(Integer.parseInt(properties.getProperty("serialPortType", String.valueOf(serialPortType))));
            hasToBeSaved = false;
            return;
        }
        catch (IOException iOException) {
            System.out.println("No INI-File, using defaults!" + System.getProperty("user.home") + "\\.CTAG.INI");
            hasToBeSaved = true;
            Settings.save();
            return;
        }
    }

    public static void save() {
        try {
            Properties properties = new Properties();
            FileOutputStream fileOutputStream = new FileOutputStream(new File(System.getProperty("user.home"), ".CTAG.INI"));
            ((Hashtable)properties).put("Locale_country", ctagLocale.getCountry());
            ((Hashtable)properties).put("Locale_language", ctagLocale.getLanguage());
            ((Hashtable)properties).put("timezone", ctagTimeZone.getID());
            ((Hashtable)properties).put("serialPort", String.valueOf(serialPort));
            ((Hashtable)properties).put("serialPortType", String.valueOf(serialPortType));
            properties.save(fileOutputStream, "Configuration file for CTAG-Library.");
            fileOutputStream.close();
            hasToBeSaved = false;
            return;
        }
        catch (IOException iOException) {
            System.out.println("Couldn't save INI-File!");
            return;
        }
    }

    public static final void setDefaultResourceBundle(String string) {
        try {
            defaultResourceBundle = ResourceBundle.getBundle(string);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("ResourceBunlde not found: " + string);
            return;
        }
    }

    public static void setLocale(Locale locale) {
        ctagLocale = locale;
        Locale.setDefault(locale);
        hasToBeSaved = true;
    }

    public static void setSerialPort(int n) {
        if (n < 10) {
            serialPort = n;
        }
    }

    public static void setSerialPortType(int n) {
        serialPortType = n;
    }

    public static void setTimeZone(TimeZone timeZone) {
        ctagTimeZone = timeZone;
        TimeZone.setDefault(timeZone);
        hasToBeSaved = true;
    }

    static {
        ctagResourceBundle = null;
        hasToBeSaved = false;
        serialPort = 0;
        ctagLocale = Locale.getDefault();
        ctagTimeZone = TimeZone.getDefault();
        Settings.load();
        try {
            ctagResourceBundle = ResourceBundle.getBundle("ctag.bundles.CtagBundle");
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("ResourceBunde for CTAG-Library not found! Using defaults.");
        }
    }
}

