/*
 * Decompiled with CFR 0.152.
 */
package ctag.exchange;

import ctag.exchange.DifDataColoum;
import ctag.exchange.DifEntry;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class DifFile {
    String iFileName = "";
    String iTitle = "CTAG exported DIF-Datafile";
    int iColoumCount;
    protected FileWriter fw;
    protected FileReader fr;

    public DifFile(String string, int n) {
        this.iFileName = string;
        this.iColoumCount = n;
    }

    public void setTitle(String string) {
        this.iTitle = string;
    }

    public void writeData(Vector vector) throws IOException {
        this.fw = new FileWriter(this.iFileName);
        this.writeHeader();
        this.writeString("TUPLES\n0," + vector.size() + "\n\"\"\n");
        this.writeString("DATA\n0,0\n\"\"\n-1,0\n");
        DifEntry difEntry = null;
        DifDataColoum difDataColoum = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            difEntry = (DifEntry)enumeration.nextElement();
            this.writeString("BOT\n");
            int n = 0;
            while (n < this.iColoumCount) {
                difDataColoum = difEntry.getDifData(n);
                if (difDataColoum.iType == 0) {
                    this.writeString("0," + difDataColoum.iData + "\nV\n");
                } else if (difDataColoum.iType == 1) {
                    this.writeString("1,0\n\"" + difDataColoum.iData + "\"\n");
                }
                ++n;
            }
            this.writeString("-1,0\n");
        }
        this.writeString("EOD\n");
        this.fw.close();
    }

    private void writeHeader() throws IOException {
        String string = "TABLE\n0,1\n\"" + this.iTitle + "\"\nVECTORS\n0," + this.iColoumCount + "\n\"\"\n";
        this.writeString(string);
    }

    private void writeString(String string) throws IOException {
        this.fw.write(string);
    }
}

