/*
 * Decompiled with CFR 0.152.
 */
package ctag.input;

import ctag.input.TextField;
import ctag.types.Amount;
import ctag.types.Currency;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;

public class AmountField
extends TextField {
    private NumberFormat formatter = NumberFormat.getCurrencyInstance();

    public AmountField() {
        this.setAmount(new Amount());
    }

    void filterKeys(KeyEvent keyEvent) {
        super.filterKeys(keyEvent);
        if (!Character.isISOControl(keyEvent.getKeyChar()) && !Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '.' && keyEvent.getKeyChar() != ',') {
            keyEvent.consume();
        }
    }

    public Amount getAmount() {
        try {
            String string = String.valueOf(this.getText()) + " DM";
            return new Amount(this.formatter.parse(string).doubleValue(), Currency.DEM);
        }
        catch (Exception exception) {
            return new Amount(0.0, Currency.DEM);
        }
    }

    void lostFocus() {
        this.setAmount(this.getAmount());
    }

    public void setAmount(Amount amount) {
        String string = this.formatter.format(amount.getValue());
        try {
            ((TextComponent)this).setText(string.substring(0, string.indexOf(32)));
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return;
        }
    }
}

