/*
 * Decompiled with CFR 0.152.
 */
package ctag.input;

import ctag.input.AmountField;
import ctag.input.InputEvent;
import ctag.input.InputListener;
import ctag.types.Amount;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;

public class AmountInput
extends Panel
implements ActionListener,
FocusListener {
    protected transient Vector aInputListener;
    protected transient Vector aFocusListener;
    private Label ivjCurrencyLabel;
    private AmountField ivjValueField;

    public AmountInput() {
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivjValueField) {
            this.processInputReady();
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.aFocusListener == null) {
            this.aFocusListener = new Vector();
        }
        this.aFocusListener.addElement(focusListener);
    }

    public void addInputListener(InputListener inputListener) {
        if (this.aInputListener == null) {
            this.aInputListener = new Vector();
        }
        this.aInputListener.addElement(inputListener);
    }

    protected void fireFocusGained(FocusEvent focusEvent) {
        if (this.aFocusListener == null) {
            return;
        }
        int n = this.aFocusListener.size();
        FocusListener focusListener = null;
        int n2 = 0;
        while (n2 < n) {
            focusListener = (FocusListener)this.aFocusListener.elementAt(n2);
            if (focusListener != null) {
                focusListener.focusGained(focusEvent);
            }
            ++n2;
        }
    }

    protected void fireFocusLost(FocusEvent focusEvent) {
        if (this.aFocusListener == null) {
            return;
        }
        int n = this.aFocusListener.size();
        FocusListener focusListener = null;
        int n2 = 0;
        while (n2 < n) {
            focusListener = (FocusListener)this.aFocusListener.elementAt(n2);
            if (focusListener != null) {
                focusListener.focusLost(focusEvent);
            }
            ++n2;
        }
    }

    protected void fireInputReady(InputEvent inputEvent) {
        if (this.aInputListener == null) {
            return;
        }
        int n = this.aInputListener.size();
        InputListener inputListener = null;
        int n2 = 0;
        while (n2 < n) {
            inputListener = (InputListener)this.aInputListener.elementAt(n2);
            if (inputListener != null) {
                inputListener.inputReady(inputEvent);
            }
            ++n2;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.ivjValueField) {
            this.fireFocusGained(focusEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.ivjValueField) {
            this.fireFocusLost(focusEvent);
        }
    }

    public Amount getAmount() {
        return this.ivjValueField.getAmount();
    }

    private void init() {
        this.setName("AmountInput");
        this.setLayout(new BorderLayout());
        this.setSize(172, 30);
        this.ivjCurrencyLabel = new Label("DM");
        this.add("East", this.ivjCurrencyLabel);
        this.ivjValueField = new AmountField();
        this.add("Center", this.ivjValueField);
        this.ivjValueField.addActionListener(this);
        this.ivjValueField.addFocusListener(this);
    }

    public Dimension preferredSize() {
        return new Dimension(172, 30);
    }

    private void processInputReady() {
        this.fireInputReady(new InputEvent(this, 0));
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this.aFocusListener != null) {
            this.aFocusListener.removeElement(focusListener);
        }
    }

    public void removeInputListener(InputListener inputListener) {
        if (this.aInputListener != null) {
            this.aInputListener.removeElement(inputListener);
        }
    }

    public void requestFocus() {
        this.ivjValueField.requestFocus();
    }

    public void setAmount(Amount amount) {
        this.ivjValueField.setAmount(amount);
        this.ivjCurrencyLabel.setText(amount.getCurrency().getSymbol());
    }
}

