/*
 * Decompiled with CFR 0.152.
 */
package ctag.input;

import ctag.input.CListBoxCanvas;
import ctag.input.CListBoxColoum;
import ctag.input.CListBoxHeaderCanvas;
import ctag.input.CListBoxItem;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemListener;
import java.util.Vector;

public class CListBox
extends Panel
implements AdjustmentListener,
ItemSelectable {
    transient ActionListener actionListener;
    private Vector coloums = new Vector();
    private boolean adjustHScroll = true;
    private boolean paintHeader = true;
    private CListBoxHeaderCanvas ivjHeadlineCanvas;
    private Panel ivjPanel1;
    private CListBoxCanvas ivjCanvas;
    private GridLayout ivjPanel1GridLayout;
    private Scrollbar ivjScrollbar1;
    private Scrollbar ivjScrollbar2;

    public CListBox() {
        this.initialize();
    }

    public CListBox(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void addColoum(CListBoxColoum cListBoxColoum) {
        this.coloums.addElement(cListBoxColoum);
        this.getHeadlineCanvas().completeWeight += cListBoxColoum.iWeight;
        this.paintItems();
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.getCanvas().addItemListener(this, itemListener);
    }

    public void addListBoxItem(CListBoxItem cListBoxItem) {
        this.addListBoxItem(cListBoxItem, -1);
    }

    public synchronized void addListBoxItem(CListBoxItem cListBoxItem, int n) {
        this.getCanvas().addListBoxItem(cListBoxItem, n);
        this.paintItems();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        switch (adjustmentEvent.getAdjustmentType()) {
            case 1: {
                if (this.getCanvas().visibleIndex >= this.getItemCount() - this.getCanvas().iLines) break;
                ++this.getCanvas().visibleIndex;
                break;
            }
            case 2: {
                if (this.getCanvas().visibleIndex <= 0) break;
                --this.getCanvas().visibleIndex;
                break;
            }
            case 4: {
                if (this.getCanvas().visibleIndex < this.getItemCount() - this.getCanvas().iLines - 10) {
                    this.getCanvas().visibleIndex += 10;
                    break;
                }
                this.getCanvas().visibleIndex = this.getItemCount() - this.getCanvas().iLines;
                break;
            }
            case 3: {
                if (this.getCanvas().visibleIndex > 10) {
                    this.getCanvas().visibleIndex -= 10;
                    break;
                }
                this.getCanvas().visibleIndex = 0;
                break;
            }
            case 5: {
                this.getCanvas().visibleIndex = adjustmentEvent.getValue();
                break;
            }
        }
        this.getCanvas().paintItems(null);
    }

    public synchronized void clear() {
        this.getCanvas().clear();
    }

    public synchronized void delListBoxItem(int n) {
        this.getCanvas().delListBoxItem(n);
    }

    private CListBoxCanvas getCanvas() {
        block2: {
            if (this.ivjCanvas != null) break block2;
            try {
                this.ivjCanvas = new CListBoxCanvas();
                this.ivjCanvas.setName("Canvas1");
                this.ivjCanvas.coloums = this.coloums;
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCanvas;
    }

    public int getColoumCount() {
        return this.coloums.size();
    }

    private CListBoxHeaderCanvas getHeadlineCanvas() {
        block2: {
            if (this.ivjHeadlineCanvas != null) break block2;
            try {
                this.ivjHeadlineCanvas = new CListBoxHeaderCanvas();
                this.ivjHeadlineCanvas.setName("HeadlinePanel");
                this.ivjHeadlineCanvas.coloums = this.coloums;
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjHeadlineCanvas;
    }

    public String getItem(int n) {
        return this.getCanvas().getItem(n);
    }

    public int getItemCount() {
        return this.getCanvas().getItemCount();
    }

    public synchronized CListBoxItem[] getItems() {
        return this.getCanvas().getItems();
    }

    private GridLayout getPanel1GridLayout() {
        GridLayout gridLayout = null;
        try {
            gridLayout = new GridLayout(0, 1);
            gridLayout.setHgap(3);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return gridLayout;
    }

    private Scrollbar getScrollbar1() {
        block2: {
            if (this.ivjScrollbar1 != null) break block2;
            try {
                this.ivjScrollbar1 = new Scrollbar();
                this.ivjScrollbar1.setName("Scrollbar1");
                this.ivjScrollbar1.setVisibleAmount(100);
                this.ivjScrollbar1.addAdjustmentListener(this);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjScrollbar1;
    }

    private Scrollbar getScrollbar2() {
        block2: {
            if (this.ivjScrollbar2 != null) break block2;
            try {
                this.ivjScrollbar2 = new Scrollbar();
                this.ivjScrollbar2.setName("Scrollbar2");
                this.ivjScrollbar2.setVisibleAmount(100);
                this.ivjScrollbar2.setEnabled(false);
                this.ivjScrollbar2.setOrientation(0);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjScrollbar2;
    }

    public synchronized int getSelectedIndex() {
        return this.getCanvas().getSelectedIndex();
    }

    public synchronized int[] getSelectedIndexes() {
        return this.getCanvas().getSelectedIndexes();
    }

    public synchronized String getSelectedItem() {
        return this.getCanvas().getSelectedItem();
    }

    public synchronized String[] getSelectedItems() {
        return this.getCanvas().getSelectedItems();
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public int getVisibleIndex() {
        return this.getCanvas().visibleIndex;
    }

    private void handleException(Throwable throwable) {
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        this.setName("CListBox");
        this.setLayout(new GridBagLayout());
        this.setSize(240, 240);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.getScrollbar1(), gridBagConstraints);
        this.add(this.getScrollbar1());
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.getScrollbar2(), gridBagConstraints3);
        this.add(this.getScrollbar2());
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 10;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 0.15;
        ((GridBagLayout)this.getLayout()).setConstraints(this.getHeadlineCanvas(), gridBagConstraints4);
        this.add(this.getHeadlineCanvas());
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.getCanvas(), gridBagConstraints2);
        this.add(this.getCanvas());
    }

    public boolean isIndexSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isMultipleMode() {
        return this.getCanvas().multipleMode;
    }

    public synchronized void makeVisible(int n) {
        this.getCanvas().visibleIndex = n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintItems();
    }

    private void paintItems() {
        if (!this.getCanvas().update) {
            return;
        }
        if (this.getColoumCount() < 1) {
            return;
        }
        if (this.adjustHScroll) {
            this.getScrollbar1().setValues(this.getCanvas().visibleIndex, this.getCanvas().iLines, 0, this.getCanvas().items.size());
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    public synchronized void remove(int n) {
        this.delListBoxItem(n);
    }

    public synchronized void remove(CListBoxItem cListBoxItem) {
        int n = this.getCanvas().items.indexOf(cListBoxItem);
        if (n < 0) {
            throw new IllegalArgumentException("item " + cListBoxItem + " not found in list");
        }
        this.remove(n);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void removeAll() {
        this.clear();
        this.getCanvas().paintItems(null);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.getCanvas().removeItemListener(itemListener);
    }

    public synchronized void replaceItem(CListBoxItem cListBoxItem, int n) {
        this.remove(n);
        this.addListBoxItem(cListBoxItem, n);
    }

    public synchronized void select(int n) {
        this.getCanvas().select(n);
    }

    public synchronized void setListBoxItems(Vector vector) {
        this.clear();
        this.getCanvas().items = vector;
        if (this.getCanvas().visibleIndex == -1) {
            this.getCanvas().visibleIndex = 0;
        }
    }

    public synchronized void setMultipleMode(boolean bl) {
        this.getCanvas().multipleMode = bl;
    }

    public void setUpdate(boolean bl) {
        this.getCanvas().setUpdate(bl);
        if (bl) {
            this.paintItems();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

