/*
 * Decompiled with CFR 0.152.
 */
package ctag.input;

import ctag.input.CListBoxColoum;
import ctag.input.CListBoxColoumItem;
import ctag.input.CListBoxItem;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class CListBoxCanvas
extends Canvas
implements ItemSelectable,
MouseListener {
    protected Vector coloums = new Vector();
    protected int iLines = 10;
    transient ItemListener itemListener;
    protected Vector items = new Vector();
    protected int LINE_HEIGHT = 15;
    protected boolean multipleMode = false;
    protected int[] selected = new int[0];
    protected boolean update = true;
    protected int visibleIndex;
    private ItemSelectable itemEventSource;

    public CListBoxCanvas() {
        this.initialize();
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void addItemListener(ItemSelectable itemSelectable, ItemListener itemListener) {
        this.itemEventSource = itemSelectable;
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void addListBoxItem(CListBoxItem cListBoxItem, int n) {
        if (n < -1 || n >= this.items.size()) {
            n = -1;
        }
        if (n == -1) {
            this.items.addElement(cListBoxItem);
        } else {
            this.items.insertElementAt(cListBoxItem, n);
        }
        if (this.visibleIndex == -1) {
            this.visibleIndex = 0;
        }
        this.paintItems(null);
    }

    public synchronized void clear() {
        this.items = new Vector();
        this.visibleIndex = -1;
        this.selected = new int[0];
    }

    public synchronized void delListBoxItem(int n) {
        this.delListBoxItems(n, n);
    }

    private synchronized void delListBoxItems(int n, int n2) {
        int n3 = n2;
        while (n3 >= n) {
            this.items.removeElementAt(n3);
            --n3;
        }
    }

    private void fireItemStateChanged(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    public int getColoumCount() {
        return this.coloums.size();
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public synchronized CListBoxItem[] getItems() {
        Object[] objectArray = new CListBoxItem[this.items.size()];
        this.items.copyInto(objectArray);
        return objectArray;
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public synchronized int[] getSelectedIndexes() {
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.getItem(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getItem(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    private void handleException(Throwable throwable) {
    }

    private void initialize() {
        this.setName("CListBoxCanvas");
        this.setName("CListBoxCanvas");
        this.setSize(160, 175);
        this.addMouseListener(this);
    }

    public boolean isIndexSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    public synchronized void makeVisible(int n) {
        this.visibleIndex = n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getY() / this.LINE_HEIGHT;
        this.select(n + this.visibleIndex);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        this.paintItems(graphics);
    }

    protected void paintItems(Graphics graphics) {
        this.paintItems(graphics, 0, this.iLines);
    }

    private void paintItems(Graphics graphics, int n, int n2) {
        if (!this.update) {
            return;
        }
        if (this.getColoumCount() < 1) {
            return;
        }
        int n3 = -3;
        if (n2 > this.iLines) {
            n2 = this.iLines;
        }
        if (n2 > this.getItemCount()) {
            n2 = this.getItemCount();
        }
        if (graphics == null) {
            graphics = this.getGraphics();
        }
        if (graphics == null) {
            return;
        }
        this.LINE_HEIGHT = graphics.getFontMetrics().getHeight();
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        this.iLines = n5 / this.LINE_HEIGHT;
        if (this.getItemCount() == 0) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n4, n5);
            return;
        }
        Color color = graphics.getColor();
        int n6 = n;
        while (n6 <= n2 && n6 + this.visibleIndex < this.items.size()) {
            CListBoxItem cListBoxItem = (CListBoxItem)this.items.elementAt(n6 + this.visibleIndex);
            if (this.isIndexSelected(n6 + this.visibleIndex)) {
                graphics.setColor(Color.gray);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.setClip(0, n6 * this.LINE_HEIGHT, n4, this.LINE_HEIGHT);
            graphics.fillRect(0, n6 * this.LINE_HEIGHT, n4, this.LINE_HEIGHT);
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < this.getColoumCount()) {
                n8 = ((CListBoxColoum)this.coloums.elementAt((int)n9)).iSize;
                CListBoxColoumItem cListBoxColoumItem = cListBoxItem.getColoum(n9);
                graphics.setClip(n7 + 1, n6 * this.LINE_HEIGHT, n8 - 2, this.LINE_HEIGHT);
                if (cListBoxColoumItem.font != null) {
                    graphics.setFont(cListBoxColoumItem.font);
                } else {
                    graphics.setFont(graphics.getFont());
                }
                if (cListBoxColoumItem.color != null) {
                    graphics.setColor(cListBoxColoumItem.color);
                } else {
                    graphics.setColor(color);
                }
                String string = cListBoxColoumItem.text;
                switch (cListBoxColoumItem.lrc) {
                    case 2: {
                        FontMetrics fontMetrics = graphics.getFontMetrics();
                        graphics.drawString(string, n7 + n8 - (fontMetrics.stringWidth(string) + 2), (n6 + 1) * this.LINE_HEIGHT + n3);
                        break;
                    }
                    case 1: {
                        FontMetrics fontMetrics = graphics.getFontMetrics();
                        graphics.drawString(string, n7 + (n8 - fontMetrics.stringWidth(string) + 2) / 2, (n6 + 1) * this.LINE_HEIGHT + n3);
                        break;
                    }
                    default: {
                        graphics.drawString(string, n7 + 1, (n6 + 1) * this.LINE_HEIGHT + n3);
                    }
                }
                n7 += n8;
                ++n9;
            }
            ++n6;
        }
        graphics.setColor(color);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized void select(int n) {
        if (n >= this.getItemCount() || n < 0) {
            return;
        }
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                return;
            }
            ++n2;
        }
        if (!this.multipleMode) {
            if (this.selected.length != 0) {
                int n3 = this.selected[0];
                this.selected = null;
                this.paintItems(null, n3 - this.visibleIndex, n3 - this.visibleIndex);
            }
            this.selected = new int[1];
            this.selected[0] = n;
            this.paintItems(null, n - this.visibleIndex, n - this.visibleIndex);
        } else {
            int[] nArray = new int[this.selected.length + 1];
            System.arraycopy(this.selected, 0, nArray, 0, this.selected.length);
            nArray[this.selected.length] = n;
            this.selected = nArray;
            this.paintItems(null);
        }
        this.fireItemStateChanged(new ItemEvent(this.itemEventSource, 701, this.items.elementAt(n), 1));
    }

    public synchronized void setMultipleMode(boolean bl) {
        this.multipleMode = bl;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
        if (this.update) {
            this.paintItems(null);
        }
    }
}

