/*
 * Decompiled with CFR 0.152.
 */
package ctag.input;

import ctag.input.TextField;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;

public class IntegerField
extends TextField {
    private NumberFormat formatter = NumberFormat.getInstance();

    public IntegerField() {
        this.setInteger(0);
    }

    void filterKeys(KeyEvent keyEvent) {
        super.filterKeys(keyEvent);
        if (!Character.isISOControl(keyEvent.getKeyChar()) && !Character.isDigit(keyEvent.getKeyChar())) {
            keyEvent.consume();
        }
    }

    public int getInteger() {
        try {
            return this.formatter.parse(this.getText()).intValue();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    void lostFocus() {
        this.setInteger(this.getInteger());
    }

    public void setInteger(int n) {
        ((TextComponent)this).setText(this.formatter.format(n));
    }
}

