/*
 * Decompiled with CFR 0.152.
 */
package ctag.input;

import ctag.input.TextField;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;

public class NumberField
extends TextField {
    private NumberFormat formatter = NumberFormat.getInstance();

    public NumberField() {
        this.setNumber(0.0);
    }

    void filterKeys(KeyEvent keyEvent) {
        super.filterKeys(keyEvent);
        if (!Character.isISOControl(keyEvent.getKeyChar()) && !Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '.' && keyEvent.getKeyChar() != ',') {
            keyEvent.consume();
        }
    }

    public double getNumber() {
        try {
            return this.formatter.parse(this.getText()).doubleValue();
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    void lostFocus() {
        this.setNumber(this.getNumber());
    }

    public void setNumber(double d) {
        ((TextComponent)this).setText(this.formatter.format(d));
    }
}

