/*
 * Decompiled with CFR 0.152.
 */
package ctag.input;

import ctag.input.TextField;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;

public class PercentField
extends TextField {
    private NumberFormat formatter = NumberFormat.getPercentInstance();

    public PercentField() {
        this.setPercent(0.16);
    }

    void filterKeys(KeyEvent keyEvent) {
        super.filterKeys(keyEvent);
        if (!Character.isISOControl(keyEvent.getKeyChar()) && !Character.isDigit(keyEvent.getKeyChar())) {
            keyEvent.consume();
        }
    }

    public double getPercent() {
        try {
            String string = String.valueOf(this.getText()) + "%";
            return this.formatter.parse(string).doubleValue();
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    void lostFocus() {
        this.setPercent(this.getPercent());
    }

    public void setPercent(double d) {
        String string = this.formatter.format(d);
        ((TextComponent)this).setText(string.substring(0, string.length() - 1));
    }
}

