/*
 * Decompiled with CFR 0.152.
 */
package ctag.input;

import ctag.input.InputEvent;
import ctag.input.InputListener;
import ctag.input.PercentField;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class PercentInput
extends Panel
implements ActionListener {
    protected transient Vector aInputListener;
    private PercentField ivjPercentField;

    public PercentInput() {
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivjPercentField) {
            this.processInputReady();
        }
    }

    public void addInputListener(InputListener inputListener) {
        if (this.aInputListener == null) {
            this.aInputListener = new Vector();
        }
        this.aInputListener.addElement(inputListener);
    }

    protected void fireInputReady(InputEvent inputEvent) {
        if (this.aInputListener == null) {
            return;
        }
        int n = this.aInputListener.size();
        InputListener inputListener = null;
        int n2 = 0;
        while (n2 < n) {
            inputListener = (InputListener)this.aInputListener.elementAt(n2);
            if (inputListener != null) {
                inputListener.inputReady(inputEvent);
            }
            ++n2;
        }
    }

    public double getPercent() {
        return this.ivjPercentField.getPercent();
    }

    private void init() {
        this.setName("PercentInput");
        this.setLayout(new BorderLayout());
        this.setSize(140, 30);
        this.ivjPercentField = new PercentField();
        this.add("Center", this.ivjPercentField);
        this.add("East", new Label("%"));
        this.ivjPercentField.addActionListener(this);
    }

    public Dimension preferredSize() {
        return new Dimension(140, 30);
    }

    private void processInputReady() {
        this.fireInputReady(new InputEvent(this, 0));
    }

    public void removeInputListener(InputListener inputListener) {
        if (this.aInputListener != null) {
            this.aInputListener.removeElement(inputListener);
        }
    }

    public void requestFocus() {
        this.ivjPercentField.requestFocus();
    }

    public void setPercent(double d) {
        this.ivjPercentField.setPercent(d);
    }
}

