/*
 * Decompiled with CFR 0.152.
 */
package ctag.types;

import ctag.types.Currency;
import java.io.Serializable;
import java.text.NumberFormat;

public class Amount
implements Serializable {
    static final long serialVersionUID = -3693090439542089510L;
    private int value;
    private Currency currency;
    static transient Currency defaultCurrency = Currency.DEM;

    public Amount() {
        this.value = 0;
        this.currency = defaultCurrency;
    }

    public Amount(double d) {
        this.value = (int)(d * 1000.0);
        this.currency = defaultCurrency;
        this.round();
    }

    public Amount(double d, Currency currency) {
        this.value = (int)(d * 1000.0);
        this.currency = currency;
        this.round();
    }

    public Amount(Amount amount) {
        this.value = amount.value;
        this.currency = amount.currency;
    }

    public Amount add(Amount amount) {
        this.addValue(amount.getValue(), amount.currency);
        return this;
    }

    public void addValue(double d, Currency currency) {
        if (this.currency == currency || this.currency.getName().equals(currency.getName())) {
            this.value += (int)(d * 1000.0);
        } else {
            this.value = (int)(this.getValue() * this.currency.getChangeValue()) + (int)((double)((int)(d * 1000.0)) * currency.getChangeValue());
            this.value = (int)((double)this.value / this.currency.getChangeValue());
        }
        this.round();
    }

    public String asNlsString() {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance();
        String string = "";
        try {
            string = numberFormat.format(this.getValue());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        return string;
    }

    public Amount divideValue(double d) {
        this.value = (int)((double)this.value / d);
        this.round();
        return this;
    }

    public static Amount fromString(String string) {
        Amount amount = new Amount();
        int n = string.indexOf(" ");
        amount.setValue(Double.valueOf(string.substring(0, n)), Currency.fromString(string.substring(n + 1, n + 4)));
        return amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getValue() {
        return (double)this.value / 1000.0;
    }

    public double getValueAsEuro() {
        if (this.currency == Currency.EUR || this.currency.getName().equals(Currency.EUR.getName())) {
            return this.getValue();
        }
        return this.getValue() * this.currency.getChangeValue();
    }

    public Amount multiplyValue(double d) {
        this.value = (int)((double)this.value * d);
        this.round();
        return this;
    }

    private void round() {
        int n = this.value - this.value / 10 * 10;
        if (n >= 5) {
            this.value += 10 - n;
            return;
        }
        this.value -= n;
    }

    public void setValue(double d, Currency currency) {
        this.value = (int)(d * 1000.0);
        this.currency = currency;
    }

    public Amount sub(Amount amount) {
        this.subValue(amount.value, amount.currency);
        return this;
    }

    public void subValue(double d, Currency currency) {
        if (this.currency == currency || this.currency.getName().equals(currency.getName())) {
            this.value = (int)((double)this.value - d);
        } else {
            this.value = (int)this.getValueAsEuro() - (int)((double)((int)(d * 1000.0)) * currency.getChangeValue());
            this.value = (int)((double)this.value / this.currency.getChangeValue());
        }
        this.round();
    }

    public String toString() {
        return new String(String.valueOf(String.valueOf((double)this.value / 1000.0)) + " " + this.currency.toString());
    }
}

