/*
 * Decompiled with CFR 0.152.
 */
package ctag.types;

public class Buffer {
    byte[] data;

    public Buffer(int n) {
        this.data = new byte[n];
    }

    public short crc16(int n) {
        int n2 = 0;
        int n3 = 0;
        while (--n >= 0) {
            n3 ^= this.getByte(n2++) << 8;
            int n4 = 0;
            while (n4 < 8) {
                n3 = (n3 & 0x8000) != 0 ? n3 << 1 ^ 0x1021 : (n3 <<= 1);
                ++n4;
            }
        }
        return (short)(n3 & 0xFFFF);
    }

    public Buffer getBuffer(int n, int n2) {
        Buffer buffer = new Buffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            buffer.setByte(n3, this.getByte(n + n3));
            ++n3;
        }
        return buffer;
    }

    public byte getByte(int n) {
        return this.data[n];
    }

    public byte[] getData() {
        return this.data;
    }

    public int getInt(int n) {
        return this.data[n] << 24 | this.data[n + 1] << 16 | this.data[n + 2] << 8 | this.data[n + 3];
    }

    public int getLen() {
        return this.data.length;
    }

    public short getShort(int n) {
        return (short)((this.data[n] & 0xFF) << 8 | this.data[n + 1] & 0xFF);
    }

    public String getString(int n) {
        int n2 = 0;
        while (this.data[n + n2] != 0) {
            ++n2;
        }
        return new String(this.data, n, n2);
    }

    public void printData() {
        int n = 0;
        while (n < this.data.length) {
            System.out.print((char)this.data[n]);
            ++n;
        }
    }

    public void setBuffer(int n, Buffer buffer) {
        int n2 = 0;
        while (n2 < buffer.size()) {
            this.setByte(n + n2, buffer.getByte(n2));
            ++n2;
        }
    }

    public void setByte(int n, byte by) {
        this.data[n] = by;
    }

    public void setInt(int n, int n2) {
        this.data[n] = (byte)(n2 >> 24 & 0xFF);
        this.data[n + 1] = (byte)(n2 >> 16 & 0xFF);
        this.data[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.data[n + 3] = (byte)(n2 & 0xFF);
    }

    public void setShort(int n, short s) {
        this.data[n] = (byte)(s >> 8 & 0xFF);
        this.data[n + 1] = (byte)(s & 0xFF);
    }

    public void setString(int n, String string) {
        if (string != null) {
            byte[] byArray = string.getBytes();
            int n2 = 0;
            while (n2 < byArray.length) {
                this.data[n + n2] = byArray[n2];
                ++n2;
            }
            this.data[n + byArray.length] = 0;
        }
    }

    public int size() {
        return this.data.length;
    }

    public String toString() {
        return super.toString();
    }
}

