/*
 * Decompiled with CFR 0.152.
 */
package ctag.types;

import ctag.types.Date;
import java.io.UnsupportedEncodingException;

public class ByteBuffer {
    public static final int PAGESIZE = 2048;
    private static String defaultCodePage = "8859_1";
    byte[] data;
    int len;
    String fieldCodePage = defaultCodePage;

    public ByteBuffer(int n) {
        this.data = new byte[n * 2048];
        this.len = 0;
        this.fieldCodePage = defaultCodePage;
    }

    public ByteBuffer appendBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            return this.appendData(byteBuffer.data, 0, byteBuffer.len);
        }
        return this;
    }

    public ByteBuffer appendByte(byte by) {
        if (this.len == this.getSize()) {
            this.grow(1);
        }
        this.data[this.len] = by;
        ++this.len;
        return this;
    }

    public ByteBuffer appendByte(int n) {
        if (this.len == this.getSize()) {
            this.grow(1);
        }
        this.data[this.len] = (byte)(n & 0xFF);
        ++this.len;
        return this;
    }

    public ByteBuffer appendData(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        if (byArray != null) {
            return this.appendData(byArray, 0, byArray.length);
        }
        return this;
    }

    public ByteBuffer appendData(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (byArray != null) {
            if (this.len + n2 > this.getSize()) {
                this.grow(n2 / 2048 + 1);
            }
            System.arraycopy(byArray, n, this.data, this.len, n2);
            this.len += n2;
        }
        return this;
    }

    public ByteBuffer appendDate(Date date) {
        this.appendInt((int)(date.getTime() / 1000L));
        return this;
    }

    public ByteBuffer appendInt(int n) {
        if (this.len + 4 > this.getSize()) {
            this.grow(1);
        }
        this.data[this.len] = (byte)(n >> 24 & 0xFF);
        this.data[this.len + 1] = (byte)(n >> 16 & 0xFF);
        this.data[this.len + 2] = (byte)(n >> 8 & 0xFF);
        this.data[this.len + 3] = (byte)(n & 0xFF);
        this.len += 4;
        return this;
    }

    public ByteBuffer appendLong(long l) {
        if (this.len + 8 > this.getSize()) {
            this.grow(1);
        }
        this.data[this.len] = (byte)(l >> 56 & 0xFFL);
        this.data[this.len + 1] = (byte)(l >> 48 & 0xFFL);
        this.data[this.len + 2] = (byte)(l >> 40 & 0xFFL);
        this.data[this.len + 3] = (byte)(l >> 32 & 0xFFL);
        this.data[this.len + 4] = (byte)(l >> 24 & 0xFFL);
        this.data[this.len + 5] = (byte)(l >> 16 & 0xFFL);
        this.data[this.len + 6] = (byte)(l >> 8 & 0xFFL);
        this.data[this.len + 7] = (byte)(l & 0xFFL);
        this.len += 8;
        return this;
    }

    public ByteBuffer appendShort(int n) {
        if (this.len + 2 > this.getSize()) {
            this.grow(1);
        }
        this.data[this.len] = (byte)(n >> 8 & 0xFF);
        this.data[this.len + 1] = (byte)(n & 0xFF);
        this.len += 2;
        return this;
    }

    public ByteBuffer appendShort(short s) {
        if (this.len + 2 > this.getSize()) {
            this.grow(1);
        }
        this.data[this.len] = (byte)(s >> 8 & 0xFF);
        this.data[this.len + 1] = (byte)(s & 0xFF);
        this.len += 2;
        return this;
    }

    public ByteBuffer appendString(String string) {
        this.appendString(string, string.length());
        this.appendByte((byte)0);
        return this;
    }

    public ByteBuffer appendString(String string, int n) {
        int n2 = n;
        if (n > string.length()) {
            n2 = string.length();
        }
        try {
            this.appendData(string.getBytes(this.fieldCodePage), 0, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.appendData(string.getBytes(), 0, n2);
        }
        if (n > string.length()) {
            int n3 = string.length();
            while (n3 < n) {
                this.appendByte((byte)0);
                ++n3;
            }
        }
        return this;
    }

    public ByteBuffer appendTreble(int n) {
        if (this.len + 3 > this.getSize()) {
            this.grow(1);
        }
        this.data[this.len] = (byte)(n >> 16 & 0xFF);
        this.data[this.len + 1] = (byte)(n >> 8 & 0xFF);
        this.data[this.len + 2] = (byte)(n & 0xFF);
        this.len += 3;
        return this;
    }

    public ByteBuffer clearBytes(int n, int n2) {
        if (n + n2 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[clearBytes()] Out of Bounds!  this.len=" + this.len + ";  to len=" + (n + n2));
        }
        --n2;
        while (n2 >= 0) {
            this.data[n + n2] = 0;
            --n2;
        }
        return this;
    }

    public short crc16(int n, int n2) {
        if (n + n2 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[crc16()] Out of Bounds!  this.len=" + this.len + ";  to len=" + (n + n2));
        }
        int n3 = n;
        int n4 = 0;
        while (--n2 >= 0) {
            n4 ^= (this.getByte(n3++) & 0xFF) << 8;
            int n5 = 0;
            while (n5 < 8) {
                n4 = (n4 & 0x8000) != 0 ? n4 << 1 ^ 0x1021 : (n4 <<= 1);
                ++n5;
            }
        }
        return (short)(n4 & 0xFFFF);
    }

    public ByteBuffer cutFirst(int n) {
        if (n >= this.len) {
            this.len = 0;
        } else {
            System.arraycopy(this.data, n, this.data, 0, this.len - n);
            this.len -= n;
        }
        return this;
    }

    public void dumpOut() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.getLength()) {
            int n3 = this.getByte(n2);
            if ((n3 &= 0xFF) < 16) {
                System.out.print("0" + Integer.toHexString(n3) + " ");
            } else {
                System.out.print(String.valueOf(Integer.toHexString(n3)) + " ");
            }
            if (++n > 15) {
                n = 0;
                System.out.println("");
            }
            ++n2;
        }
        System.out.println("");
    }

    public void dumpOut(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n + n2 && n4 < this.getLength()) {
            int n5 = this.getByte(n4);
            if ((n5 &= 0xFF) < 16) {
                System.out.print("0" + Integer.toHexString(n5) + " ");
            } else {
                System.out.print(String.valueOf(Integer.toHexString(n5)) + " ");
            }
            if (++n3 > 15) {
                n3 = 0;
                System.out.println("");
            }
            ++n4;
        }
        System.out.println("");
    }

    public int findFirst(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < this.len - byArray.length) {
            n2 = 0;
            while (n2 < byArray.length) {
                if (this.data[n + n2] != byArray[n2]) break;
                ++n2;
            }
            if (n2 == byArray.length) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findLast(byte[] byArray) {
        int n = this.len - byArray.length;
        int n2 = 0;
        while (n >= 0) {
            n2 = 0;
            while (n2 < byArray.length) {
                if (this.data[n + n2] != byArray[n2]) break;
                ++n2;
            }
            if (n2 == byArray.length) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public ByteBuffer getBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(this.getPages());
        System.arraycopy(this.data, 0, byteBuffer.data, 0, this.len);
        byteBuffer.len = this.len;
        return byteBuffer;
    }

    public ByteBuffer getBuffer(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n + n2 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[getData()] Out of Bounds!  this.len=" + this.len + ";  to len=" + (n + n2));
        }
        ByteBuffer byteBuffer = new ByteBuffer(n2 / 2048 + 1);
        System.arraycopy(this.data, n, byteBuffer.data, 0, n2);
        byteBuffer.len = n2;
        return byteBuffer;
    }

    public byte getByte(int n) throws ArrayIndexOutOfBoundsException {
        if (n + 1 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[getByte()] Index out of Bounds!");
        }
        return this.data[n];
    }

    public byte[] getData() throws ArrayIndexOutOfBoundsException {
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.data, 0, byArray, 0, this.len);
        return byArray;
    }

    public byte[] getData(int n) throws ArrayIndexOutOfBoundsException {
        if (n > this.len) {
            throw new ArrayIndexOutOfBoundsException("[getData()] Out of Bounds!");
        }
        int n2 = this.getLength() - n;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, n, byArray, 0, n2);
        return byArray;
    }

    public byte[] getData(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n + n2 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[getData()] Out of Bounds!");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, n, byArray, 0, n2);
        return byArray;
    }

    public Date getDate(int n) {
        return new Date((long)this.getInt(n) * 1000L);
    }

    public int getInt(int n) throws ArrayIndexOutOfBoundsException {
        if (n + 4 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[getInt()] Index out of Bounds!");
        }
        return (this.data[n] & 0xFF) << 24 | (this.data[n + 1] & 0xFF) << 16 | (this.data[n + 2] & 0xFF) << 8 | this.data[n + 3] & 0xFF;
    }

    public int getLength() {
        return this.len;
    }

    public long getLong(int n) throws ArrayIndexOutOfBoundsException {
        if (n + 8 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[getLong()] Index out of Bounds!");
        }
        return (this.data[n] & 0xFF) << 56 | (this.data[n + 1] & 0xFF) << 48 | (this.data[n + 2] & 0xFF) << 40 | (this.data[n + 3] & 0xFF) << 32 | (this.data[n + 4] & 0xFF) << 24 | (this.data[n + 5] & 0xFF) << 16 | (this.data[n + 6] & 0xFF) << 8 | this.data[n + 7] & 0xFF;
    }

    public int getPages() {
        return this.data.length / 2048 + 1;
    }

    public short getShort(int n) throws ArrayIndexOutOfBoundsException {
        if (n + 2 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[getShort()] Index out of Bounds!");
        }
        return (short)((this.data[n] & 0xFF) << 8 | this.data[n + 1] & 0xFF);
    }

    public int getSize() {
        return this.data.length;
    }

    public String getString(int n) {
        String string;
        int n2 = 0;
        while (this.data[n + n2] != 0 && n + n2 <= this.len) {
            ++n2;
        }
        try {
            string = new String(this.data, n, n2, this.fieldCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(this.data, n, n2);
        }
        return string;
    }

    public String getString(int n, int n2) {
        int n3 = 0;
        while (this.data[n + n3] != 0 && n3 < n2 && n + n3 <= this.len) {
            ++n3;
        }
        String string = null;
        try {
            string = new String(this.data, n, n3, this.fieldCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(this.data, n, n3);
        }
        return string;
    }

    public int getTreble(int n) throws ArrayIndexOutOfBoundsException {
        if (n + 3 > this.len) {
            throw new ArrayIndexOutOfBoundsException("[getTreble()] Index out of Bounds!");
        }
        return (this.data[n] & 0xFF) << 16 | (this.data[n + 1] & 0xFF) << 8 | this.data[n + 2] & 0xFF;
    }

    public ByteBuffer grow(int n) {
        byte[] byArray = new byte[this.data.length + n * 2048];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
        return this;
    }

    public ByteBuffer reset() {
        this.len = 0;
        return this;
    }

    public ByteBuffer setBuffer(int n, ByteBuffer byteBuffer) throws ArrayIndexOutOfBoundsException {
        if (this.len + byteBuffer.getLength() > this.data.length) {
            this.grow(byteBuffer.getPages());
        }
        System.arraycopy(byteBuffer.data, 0, this.data, n, byteBuffer.getLength());
        if (n + byteBuffer.getLength() > this.len) {
            this.len = n + byteBuffer.getLength();
        }
        return this;
    }

    public ByteBuffer setByte(int n, byte by) {
        this.data[n] = by;
        return this;
    }

    public static final void setCodePage(String string) {
        defaultCodePage = string;
    }

    public ByteBuffer setData(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        if (this.len + byArray.length > this.data.length) {
            this.grow(byArray.length / 2048 + 1);
        }
        System.arraycopy(byArray, 0, this.data, n, byArray.length);
        if (n + byArray.length > this.len) {
            this.len = n + byArray.length;
        }
        return this;
    }

    public ByteBuffer setInt(int n, int n2) {
        this.data[n] = (byte)(n2 >> 24 & 0xFF);
        this.data[n + 1] = (byte)(n2 >> 16 & 0xFF);
        this.data[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.data[n + 3] = (byte)(n2 & 0xFF);
        if (n + 4 > this.len) {
            this.len = n + 4;
        }
        return this;
    }

    public ByteBuffer setShort(int n, int n2) {
        this.data[n] = (byte)(n2 >> 8 & 0xFF);
        this.data[n + 1] = (byte)(n2 & 0xFF);
        if (n + 2 > this.len) {
            this.len = n + 2;
        }
        return this;
    }

    public ByteBuffer setShort(int n, short s) {
        this.data[n] = (byte)(s >> 8 & 0xFF);
        this.data[n + 1] = (byte)(s & 0xFF);
        if (n + 2 > this.len) {
            this.len = n + 2;
        }
        return this;
    }

    public ByteBuffer setString(int n, String string) throws ArrayIndexOutOfBoundsException {
        try {
            this.setData(n, string.getBytes(this.fieldCodePage));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.setData(n, string.getBytes());
        }
        return this;
    }

    public ByteBuffer setTreble(int n, int n2) {
        this.data[n] = (byte)(n2 >> 16 & 0xFF);
        this.data[n + 1] = (byte)(n2 >> 8 & 0xFF);
        this.data[n + 2] = (byte)(n2 & 0xFF);
        if (n + 3 > this.len) {
            this.len = n + 3;
        }
        return this;
    }

    public String toString() {
        return "[ByteArray; len: " + this.len + ";datalen: " + this.data.length + "]";
    }
}

