/*
 * Decompiled with CFR 0.152.
 */
package ctag.types;

import java.io.IOException;

public class ByteQueue {
    private byte[] myBuffer;
    private int bufferSize;
    private int bufferReadPos;
    private int bufferWritePos;
    private boolean empty = true;

    public ByteQueue() {
        this.bufferSize = 512;
        this.initBuffer();
    }

    public ByteQueue(int n) {
        this.bufferSize = n;
        this.initBuffer();
    }

    private boolean bufferIsFull() {
        return this.bufferReadPos == this.bufferWritePos && !this.empty;
    }

    public int bytesAvailable() {
        if (this.bufferWritePos < this.bufferReadPos) {
            return this.bufferSize - (this.bufferReadPos - this.bufferWritePos);
        }
        return this.bufferWritePos - this.bufferReadPos;
    }

    public byte enque() throws IOException {
        byte by = 0;
        if (!this.empty) {
            by = this.myBuffer[this.bufferReadPos];
            ++this.bufferReadPos;
            if (this.bufferReadPos == this.bufferSize) {
                this.bufferReadPos = 0;
            }
            if (this.bufferReadPos == this.bufferWritePos) {
                this.empty = true;
            }
        } else {
            throw new IOException("Read-ERROR: Buffer is empty.");
        }
        return by;
    }

    public boolean flush() {
        return this.empty;
    }

    private void initBuffer() {
        this.myBuffer = new byte[this.bufferSize];
    }

    public void inque(byte by) throws IOException {
        if (this.bufferIsFull()) {
            throw new IOException("Write-ERROR: Buffer is full.");
        }
        this.myBuffer[this.bufferWritePos] = by;
        ++this.bufferWritePos;
        if (this.bufferWritePos == this.bufferSize) {
            this.bufferWritePos = 0;
        }
        this.empty = false;
    }
}

