/*
 * Decompiled with CFR 0.152.
 */
package ctag.types;

import java.io.Serializable;

public class Currency
implements Serializable {
    private int type;
    private double changeValue = 1.0;
    public static final transient String[] names = new String[]{"EUR", "DEM", "USD"};
    public static final transient String[] symbols = new String[]{"\u20ac", "DM", "$"};
    public static final transient Currency EUR = new Currency(0, 1.0);
    public static final transient Currency DEM = new Currency(1, 0.5);
    public static final transient Currency USD = new Currency(2, 0.8);
    private static transient Currency[] objs = new Currency[3];
    static final long serialVersionUID = -7020281359942637252L;

    private Currency(int n, double d) {
        this.type = n;
        this.changeValue = d;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Currency fromString(String string) {
        int n = 0;
        while (n < names.length) {
            if (names[n].equals(string)) {
                return objs[n];
            }
            ++n;
        }
        return null;
    }

    public double getChangeValue() {
        return this.changeValue;
    }

    public String getName() {
        return names[this.type];
    }

    public String getSymbol() {
        return symbols[this.type];
    }

    public static String[] getSymbols() {
        return symbols;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return symbols[this.type];
    }

    static {
        Currency.objs[0] = EUR;
        Currency.objs[1] = DEM;
        Currency.objs[2] = USD;
    }
}

