/*
 * Decompiled with CFR 0.152.
 */
package Address;

import Address.Entry;
import all.ConfigFile;
import all.DatFile;
import all.EntryList;
import ctag.config.Settings;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;

public final class AddressFile
extends DatFile {
    private String fieldFile = "address\\address.dat";
    String HeaderEnd;
    String Unknown1;
    String Unknown2;
    String Unknown3;
    String Unknown4;
    String Unknown5;
    String Unknown6;
    String Unknown7;
    String fieldCustomLabel1 = Settings.getNLSString((String)"Custom 1");
    String fieldCustomLabel2 = Settings.getNLSString((String)"Custom 2");
    String fieldCustomLabel3 = Settings.getNLSString((String)"Custom 3");
    String fieldCustomLabel4 = Settings.getNLSString((String)"Birthday");

    public AddressFile() {
        this.Token = 1094844672L;
        this.HeaderEnd = "01234" + '\n' + "1" + '\n' + "2" + '\n' + "0000000000001000" + '\n' + "12" + '\n' + "1" + '\n' + "0000" + '\n';
        this.FieldTypes = new short[30];
        this.FieldTypes[29] = 1;
        this.FieldTypes[24] = 1;
        this.FieldTypes[15] = 1;
        this.FieldTypes[13] = 1;
        this.FieldTypes[11] = 1;
        this.FieldTypes[9] = 1;
        this.FieldTypes[7] = 1;
        this.FieldTypes[2] = 1;
        this.FieldTypes[1] = 1;
        this.FieldTypes[0] = 1;
        this.FieldTypes[28] = 5;
        this.FieldTypes[27] = 5;
        this.FieldTypes[26] = 5;
        this.FieldTypes[25] = 5;
        this.FieldTypes[22] = 5;
        this.FieldTypes[21] = 5;
        this.FieldTypes[20] = 5;
        this.FieldTypes[19] = 5;
        this.FieldTypes[18] = 5;
        this.FieldTypes[17] = 5;
        this.FieldTypes[16] = 5;
        this.FieldTypes[14] = 5;
        this.FieldTypes[12] = 5;
        this.FieldTypes[10] = 5;
        this.FieldTypes[8] = 5;
        this.FieldTypes[6] = 5;
        this.FieldTypes[5] = 5;
        this.FieldTypes[4] = 5;
        this.FieldTypes[3] = 5;
        this.FieldTypes[23] = 6;
        this.TabDesc[1] = 30L;
    }

    public void exportCommunicatorTXT(String string) {
        try {
            System.out.println("Exporting " + string + "...");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "8859_1");
            Entry entry = null;
            Enumeration enumeration = this.getEntries().elements();
            while (enumeration.hasMoreElements()) {
                entry = (Entry)enumeration.nextElement();
                outputStreamWriter.write("[RECORD]\r\n");
                outputStreamWriter.write("[FIELD]\r\nName\r\n[FIELD-NAME]\r\n[FIELD-DATA]\r\n");
                if (!entry.getName().equals("") && !entry.getName().equals("\r\n")) {
                    outputStreamWriter.write(entry.getName());
                    outputStreamWriter.write("\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[FIELD]\r\nCompany\r\n[FIELD-NAME]\r\n[FIELD-DATA]\r\n");
                if (!entry.getCompany().equals("") && !entry.getCompany().equals("\r\n")) {
                    outputStreamWriter.write(entry.getCompany());
                    outputStreamWriter.write("\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[FIELD]\r\nJob Title\r\n[FIELD-NAME]\r\n[FIELD-DATA]\r\n");
                if (!entry.getTitle().equals("") && !entry.getTitle().equals("\r\n")) {
                    outputStreamWriter.write(entry.getTitle());
                    outputStreamWriter.write("\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[FIELD]\r\nAddress\r\n[FIELD-NAME]\r\n[FIELD-DATA]\r\n");
                if (!entry.getAddress().equals("") && !entry.getAddress().equals("\r\n")) {
                    outputStreamWriter.write(entry.getAddress());
                    outputStreamWriter.write("\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[FIELD]\r\nTel\r\n[FIELD-NAME]\r\n[FIELD-DATA]\r\n");
                if (!entry.getPhone(0).equals("") && !entry.getPhone(0).equals("\r\n")) {
                    outputStreamWriter.write(String.valueOf(entry.getPhone(0)) + "\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[FIELD]\r\nTel\r\n[FIELD-NAME]\r\nGSM/PCN\r\n[FIELD-DATA]\r\n");
                if (!entry.getPhone(1).equals("") && !entry.getPhone(1).equals("\r\n")) {
                    outputStreamWriter.write(String.valueOf(entry.getPhone(1)) + "\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[FIELD]\r\nFax\r\n[FIELD-NAME]\r\n[FIELD-DATA]\r\n");
                if (!entry.getPhone(2).equals("") && !entry.getPhone(2).equals("\r\n")) {
                    outputStreamWriter.write(String.valueOf(entry.getPhone(2)) + "\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[FIELD]\r\nFax\r\n[FIELD-NAME]\r\nGSM/PCN\r\n[FIELD-DATA]\r\n");
                if (!entry.getPhone(3).equals("") && !entry.getPhone(3).equals("\r\n")) {
                    outputStreamWriter.write(String.valueOf(entry.getPhone(3)) + "\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[FIELD]\r\nMail\r\n[FIELD-NAME]\r\n[FIELD-DATA]\r\n");
                if (!entry.getPhone(4).equals("") && !entry.getPhone(4).equals("\r\n")) {
                    outputStreamWriter.write(String.valueOf(entry.getPhone(4)) + "\r\n");
                }
                outputStreamWriter.write("[FIELD-END]\r\n");
                outputStreamWriter.write("[RECORD-END]\r\n");
            }
            outputStreamWriter.close();
            System.out.println("Ready!");
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public String getCustomLabel1() {
        if (this.fieldCustomLabel1 == null) {
            this.fieldCustomLabel1 = "Custom 1";
        }
        return this.fieldCustomLabel1;
    }

    public String getCustomLabel2() {
        if (this.fieldCustomLabel2 == null) {
            this.fieldCustomLabel2 = "Custom 2";
        }
        return this.fieldCustomLabel2;
    }

    public String getCustomLabel3() {
        if (this.fieldCustomLabel3 == null) {
            this.fieldCustomLabel3 = "Custom 3";
        }
        return this.fieldCustomLabel3;
    }

    public String getCustomLabel4() {
        if (this.fieldCustomLabel4 == null) {
            this.fieldCustomLabel4 = "Custom 4";
        }
        return this.fieldCustomLabel4;
    }

    public void importCommunicatorTXT(String string) {
        EntryList entryList = new EntryList(10, 1);
        try {
            System.out.println("Importing " + string + "...");
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
            String string2 = "";
            String string3 = "";
            StringBuffer stringBuffer = null;
            Entry entry = null;
            string3 = lineNumberReader.readLine();
            boolean bl = true;
            while (string3 != null) {
                if (string3.startsWith("[RECORD]")) {
                    entry = new Entry();
                    bl = true;
                } else if (string3.startsWith("[RECORD-END]")) {
                    entryList.add(entry);
                    bl = true;
                } else if (string3.startsWith("[FIELD]")) {
                    string2 = lineNumberReader.readLine();
                    stringBuffer = new StringBuffer();
                    bl = true;
                } else if (string3.startsWith("[FIELD-NAME]")) {
                    do {
                        if ((string3 = lineNumberReader.readLine()).startsWith("[")) continue;
                        string2 = String.valueOf(string2) + string3;
                    } while (!string3.startsWith("["));
                    stringBuffer = new StringBuffer();
                    bl = false;
                } else if (string3.startsWith("[FIELD-DATA]")) {
                    do {
                        if ((string3 = lineNumberReader.readLine()).startsWith("[")) continue;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("\n");
                        }
                        stringBuffer.append(string3.getBytes("8859_1"));
                    } while (!string3.startsWith("["));
                    bl = false;
                    if (string2.equals("Name")) {
                        entry.setName(new String(stringBuffer));
                    } else if (string2.equals("Company")) {
                        entry.setCompany(new String(stringBuffer));
                    } else if (string2.equals("Address")) {
                        entry.setAddress(new String(stringBuffer));
                    } else if (string2.equals("Tel")) {
                        entry.setPhone(0, new String(stringBuffer));
                        entry.setPhoneId(0, 0);
                    } else if (string2.equals("TelGSM/PCN")) {
                        entry.setPhone(1, new String(stringBuffer));
                        entry.setPhoneId(1, 0);
                    } else if (string2.equals("Fax")) {
                        entry.setPhone(2, new String(stringBuffer));
                        entry.setPhoneId(2, 2);
                    } else if (string2.equals("FaxGSM/PCN")) {
                        entry.setPhone(3, new String(stringBuffer));
                        entry.setPhoneId(3, 2);
                    } else if (string2.equals("Mail")) {
                        entry.setPhone(4, new String(stringBuffer));
                        entry.setPhoneId(4, 4);
                    } else if (string2.equals("Job Title")) {
                        entry.setTitle(new String(stringBuffer));
                    }
                }
                if (bl) {
                    string3 = lineNumberReader.readLine();
                }
                bl = true;
            }
            System.out.println("Ready!");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        entryList.sort();
        this.setEntries(entryList);
        this.setWriteOk(false);
    }

    public final Entry makeNewEntry(int n) {
        return new Entry(n);
    }

    public void read() {
        try {
            this.open(String.valueOf(ConfigFile.getDataPath()) + this.fieldFile, true);
            this.readHeader();
            this.readCategories();
            this.readTableDescription();
            int n = this.readLong() / 30;
            EntryList entryList = new EntryList(n, 1);
            Entry entry = null;
            int n2 = 0;
            while (n2 < n) {
                entry = new Entry();
                entry.read(this);
                entryList.add(entry);
                ++n2;
            }
            this.fis.close();
            entryList.sort();
            this.setEntries(entryList);
            this.setWriteOk(false);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            System.out.println("Could not read Address-Data!");
            System.out.println(iOException.getMessage());
            return;
        }
    }

    public void readHeader() throws IOException {
        int n;
        super.readHeader();
        int n2 = n = 0;
        n = this.Header.indexOf(10, n + 1);
        this.setCustomLabel1(this.Header.substring(n2, n));
        int n3 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.setCustomLabel2(this.Header.substring(n3, n));
        int n4 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.setCustomLabel3(this.Header.substring(n4, n));
        int n5 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.setCustomLabel4(this.Header.substring(n5, n));
        this.HeaderEnd = this.Header.substring(n + 1);
        int n6 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.Unknown1 = this.Header.substring(n6, n);
        int n7 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.Unknown2 = this.Header.substring(n7, n);
        int n8 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.Unknown3 = this.Header.substring(n8, n);
        int n9 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.Unknown4 = this.Header.substring(n9, n);
        int n10 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.Unknown5 = this.Header.substring(n10, n);
        int n11 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.Unknown6 = this.Header.substring(n11, n);
        int n12 = n + 1;
        n = this.Header.indexOf(10, n + 1);
        this.Unknown7 = this.Header.substring(n12, n);
    }

    public void saveEntry(Entry entry) {
        if (!this.getEntries().contains(entry)) {
            this.getEntries().add(entry);
        }
        this.setWriteOk(true);
    }

    public void setCustomLabel1(String string) {
        String string2 = this.fieldCustomLabel1;
        this.fieldCustomLabel1 = string;
        this.firePropertyChange("customLabel1", string2, string);
        this.setWriteOk(true);
    }

    public void setCustomLabel2(String string) {
        String string2 = this.fieldCustomLabel2;
        this.fieldCustomLabel2 = string;
        this.firePropertyChange("customLabel2", string2, string);
        this.setWriteOk(true);
    }

    public void setCustomLabel3(String string) {
        String string2 = this.fieldCustomLabel3;
        this.fieldCustomLabel3 = string;
        this.firePropertyChange("customLabel3", string2, string);
        this.setWriteOk(true);
    }

    public void setCustomLabel4(String string) {
        String string2 = this.fieldCustomLabel4;
        this.fieldCustomLabel4 = string;
        this.firePropertyChange("customLabel4", string2, string);
        this.setWriteOk(true);
    }

    public void write() {
        if (!this.getWriteOk()) {
            return;
        }
        try {
            this.open(String.valueOf(ConfigFile.getDataPath()) + this.fieldFile, false);
            this.writeHeader();
            this.writeCategories();
            this.writeTableDescription();
            this.writeLong(this.getEntries().size() * 30);
            Enumeration enumeration = this.getEntries().elements();
            while (enumeration.hasMoreElements()) {
                ((Entry)enumeration.nextElement()).write(this);
            }
            this.fos.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("EXPECTION during write! " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
    }

    public void writeHeader() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCustomLabel1());
        stringBuffer.append('\n');
        stringBuffer.append(this.getCustomLabel2());
        stringBuffer.append('\n');
        stringBuffer.append(this.getCustomLabel3());
        stringBuffer.append('\n');
        stringBuffer.append(this.getCustomLabel4());
        stringBuffer.append('\n');
        stringBuffer.append(this.HeaderEnd);
        this.writeCString(new String(stringBuffer), false);
    }
}

