/*
 * Decompiled with CFR 0.152.
 */
package Address;

import all.ConfigFile;
import all.DatFile;
import ctag.pilot.AddressRecord;
import ctag.pilot.Record;
import java.io.IOException;

public final class Entry
extends all.Entry {
    String fieldName = "";
    String fieldFirst = "";
    String fieldTitle = "";
    String fieldCompany = "";
    String fieldCity = "";
    String fieldState = "";
    String fieldZipCode = "";
    String fieldAddress = "";
    String fieldCountry = "";
    String fieldNote = "";
    int fieldDisplayPhoneId;
    int[] fieldPhoneId = new int[5];
    String[] fieldPhone = new String[5];
    String[] fieldCustom = new String[4];

    public Entry() {
        this.fieldPhoneId[0] = 0;
        this.fieldPhoneId[1] = 1;
        this.fieldPhoneId[2] = 2;
        this.fieldPhoneId[3] = 3;
        this.fieldPhoneId[4] = 4;
    }

    public Entry(int n) {
        super(n);
    }

    public Entry(AddressRecord addressRecord) {
        super((Record)addressRecord);
        this.setDisplayPhoneId(addressRecord.showPhoneId + 1);
        this.setPhoneId(4, addressRecord.phoneLabelId[4]);
        this.setPhoneId(3, addressRecord.phoneLabelId[3]);
        this.setPhoneId(2, addressRecord.phoneLabelId[2]);
        this.setPhoneId(1, addressRecord.phoneLabelId[1]);
        this.setPhoneId(0, addressRecord.phoneLabelId[0]);
        String string = null;
        int n = 0;
        while (n < 19) {
            string = addressRecord.entries[n] != null ? addressRecord.entries[n] : "";
            switch (n) {
                case 0: {
                    this.setName(string);
                    break;
                }
                case 1: {
                    this.setFirst(string);
                    break;
                }
                case 2: {
                    this.setCompany(string);
                    break;
                }
                case 3: {
                    this.setPhone(0, string);
                    break;
                }
                case 4: {
                    this.setPhone(1, string);
                    break;
                }
                case 5: {
                    this.setPhone(2, string);
                    break;
                }
                case 6: {
                    this.setPhone(3, string);
                    break;
                }
                case 7: {
                    this.setPhone(4, string);
                    break;
                }
                case 8: {
                    this.setAddress(string);
                    break;
                }
                case 9: {
                    this.setCity(string);
                    break;
                }
                case 10: {
                    this.setState(string);
                    break;
                }
                case 11: {
                    this.setZipCode(string);
                    break;
                }
                case 12: {
                    this.setCountry(string);
                    break;
                }
                case 13: {
                    this.setTitle(string);
                    break;
                }
                case 14: {
                    this.setCustom(0, string);
                    break;
                }
                case 15: {
                    this.setCustom(1, string);
                    break;
                }
                case 16: {
                    this.setCustom(2, string);
                    break;
                }
                case 17: {
                    this.setCustom(3, string);
                    break;
                }
                case 18: {
                    this.setNote(string);
                    break;
                }
            }
            ++n;
        }
    }

    public int compare(Object object) {
        return ((Entry)object).getBrowseString().compareTo(this.getBrowseString());
    }

    public String getAddress() {
        block2: {
            if (this.fieldAddress != null) break block2;
            try {
                this.fieldAddress = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating address property.");
            }
        }
        return this.fieldAddress;
    }

    public AddressRecord getAddressRecord() {
        AddressRecord addressRecord = new AddressRecord(super.getRecord(), false);
        addressRecord.showPhoneId = this.getDisplayPhoneId() - 1;
        addressRecord.phoneLabelId[0] = this.getPhoneId(0);
        addressRecord.phoneLabelId[1] = this.getPhoneId(1);
        addressRecord.phoneLabelId[2] = this.getPhoneId(2);
        addressRecord.phoneLabelId[3] = this.getPhoneId(3);
        addressRecord.phoneLabelId[4] = this.getPhoneId(4);
        addressRecord.entries[0] = this.getName();
        addressRecord.entries[1] = this.getFirst();
        addressRecord.entries[2] = this.getCompany();
        addressRecord.entries[3] = this.getPhone(0);
        addressRecord.entries[4] = this.getPhone(1);
        addressRecord.entries[5] = this.getPhone(2);
        addressRecord.entries[6] = this.getPhone(3);
        addressRecord.entries[7] = this.getPhone(4);
        addressRecord.entries[8] = this.getAddress();
        addressRecord.entries[9] = this.getCity();
        addressRecord.entries[10] = this.getState();
        addressRecord.entries[11] = this.getZipCode();
        addressRecord.entries[12] = this.getCountry();
        addressRecord.entries[13] = this.getTitle();
        addressRecord.entries[14] = this.getCustom(0);
        addressRecord.entries[15] = this.getCustom(1);
        addressRecord.entries[16] = this.getCustom(2);
        addressRecord.entries[17] = this.getCustom(3);
        addressRecord.entries[18] = this.getNote();
        return addressRecord;
    }

    public String getBrowseString() {
        if (ConfigFile.getHideState() && this.getIsPrivate()) {
            return null;
        }
        try {
            String string = "";
            if (this.fieldCompany != null && !this.fieldCompany.equals("")) {
                string = String.valueOf(this.fieldCompany) + ", ";
            }
            if (this.fieldName.equals("")) {
                return String.valueOf((String.valueOf(string) + this.fieldFirst + "                   ").substring(0, 20)) + this.getPhone(this.getDisplayPhoneId() - 1);
            }
            if (this.fieldFirst.equals("")) {
                return String.valueOf((String.valueOf(string) + this.fieldName + "                   ").substring(0, 20)) + this.getPhone(this.getDisplayPhoneId() - 1);
            }
            return String.valueOf((String.valueOf(this.fieldName) + ", " + this.fieldFirst + "                   ").substring(0, 20)) + this.getPhone(this.getDisplayPhoneId() - 1);
        }
        catch (Throwable throwable) {
            return this.fieldName;
        }
    }

    public String getCity() {
        block2: {
            if (this.fieldCity != null) break block2;
            try {
                this.fieldCity = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating city property.");
            }
        }
        return this.fieldCity;
    }

    public String getCompany() {
        block2: {
            if (this.fieldCompany != null) break block2;
            try {
                this.fieldCompany = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating company property.");
            }
        }
        return this.fieldCompany;
    }

    public String getCountry() {
        block2: {
            if (this.fieldCountry != null) break block2;
            try {
                this.fieldCountry = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating country property.");
            }
        }
        return this.fieldCountry;
    }

    public String[] getCustom() {
        return this.fieldCustom;
    }

    public String getCustom(int n) {
        return this.getCustom()[n];
    }

    public int getDisplayPhoneId() {
        return this.fieldDisplayPhoneId;
    }

    public String getFirst() {
        block2: {
            if (this.fieldFirst != null) break block2;
            try {
                this.fieldFirst = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating first property.");
            }
        }
        return this.fieldFirst;
    }

    public String getName() {
        block2: {
            if (this.fieldName != null) break block2;
            try {
                this.fieldName = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating name property.");
            }
        }
        return this.fieldName;
    }

    public String getNote() {
        block2: {
            if (this.fieldNote != null) break block2;
            try {
                this.fieldNote = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating note property.");
            }
        }
        return this.fieldNote;
    }

    public String[] getPhone() {
        return this.fieldPhone;
    }

    public String getPhone(int n) {
        return this.getPhone()[n];
    }

    public int[] getPhoneId() {
        return this.fieldPhoneId;
    }

    public int getPhoneId(int n) {
        return this.getPhoneId()[n];
    }

    public static String getPhoneLabel(int n) {
        String[] stringArray = new String[]{"Work", "Home", "Fax", "Other", "E-mail", "Main", "Pager", "Mobile"};
        if (n > stringArray.length) {
            return "";
        }
        return stringArray[n];
    }

    public String getState() {
        block2: {
            if (this.fieldState != null) break block2;
            try {
                this.fieldState = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating state property.");
            }
        }
        return this.fieldState;
    }

    public String getTitle() {
        block2: {
            if (this.fieldTitle != null) break block2;
            try {
                this.fieldTitle = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating title property.");
            }
        }
        return this.fieldTitle;
    }

    public String getZipCode() {
        block2: {
            if (this.fieldZipCode != null) break block2;
            try {
                this.fieldZipCode = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating zipCode property.");
            }
        }
        return this.fieldZipCode;
    }

    public void read(DatFile datFile) throws IOException {
        super.read(datFile);
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setName(datFile.readCString(true));
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setFirst(datFile.readCString(true));
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setTitle(datFile.readCString(true));
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setCompany(datFile.readCString(true));
        int n = 0;
        while (n < 5) {
            datFile.readLong();
            this.setPhoneId(n, datFile.readLong());
            if (datFile.readLong() != 5) {
                throw new IOException("Wrong File Format: String expected!");
            }
            datFile.readLong();
            this.setPhone(n, datFile.readCString(true));
            ++n;
        }
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setAddress(datFile.readCString(true));
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setCity(datFile.readCString(true));
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setState(datFile.readCString(true));
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setZipCode(datFile.readCString(true));
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setCountry(datFile.readCString(true));
        if (datFile.readLong() != 5) {
            throw new IOException("Wrong File Format: String expected!");
        }
        datFile.readLong();
        this.setNote(datFile.readCString(true));
        datFile.readLong();
        this.setIsPrivate(datFile.readLong() != 0);
        datFile.readLong();
        this.setCategoryId(datFile.readLong());
        int n2 = 0;
        while (n2 < 4) {
            if (datFile.readLong() != 5) {
                throw new IOException("Wrong File Format: String expected!");
            }
            datFile.readLong();
            this.setCustom(n2, datFile.readCString(true));
            ++n2;
        }
        datFile.readLong();
        this.setDisplayPhoneId(datFile.readLong());
    }

    public void setAddress(String string) {
        String string2 = this.fieldAddress;
        this.fieldAddress = string;
        this.firePropertyChange("address", string2, string);
    }

    public void setCity(String string) {
        String string2 = this.fieldCity;
        this.fieldCity = string;
        this.firePropertyChange("city", string2, string);
    }

    public void setCompany(String string) {
        String string2 = this.fieldCompany;
        this.fieldCompany = string;
        this.firePropertyChange("company", string2, string);
    }

    public void setCountry(String string) {
        String string2 = this.fieldCountry;
        this.fieldCountry = string;
        this.firePropertyChange("country", string2, string);
    }

    public void setCustom(String[] stringArray) {
        String[] stringArray2 = this.fieldCustom;
        this.fieldCustom = stringArray;
        this.firePropertyChange("custom", stringArray2, stringArray);
    }

    public void setCustom(int n, String string) {
        String[] stringArray = this.fieldCustom;
        this.fieldCustom[n] = string;
        this.firePropertyChange("custom", stringArray, this.fieldCustom);
    }

    public void setDisplayPhoneId(int n) {
        int n2 = this.fieldDisplayPhoneId;
        this.fieldDisplayPhoneId = n;
        this.firePropertyChange("displayPhoneId", new Integer(n2), new Integer(n));
    }

    public void setFirst(String string) {
        String string2 = this.fieldFirst;
        this.fieldFirst = string;
        this.firePropertyChange("first", string2, string);
    }

    public void setName(String string) {
        String string2 = this.fieldName;
        this.fieldName = string;
        this.firePropertyChange("name", string2, string);
    }

    public void setNote(String string) {
        String string2 = this.fieldNote;
        this.fieldNote = string;
        this.firePropertyChange("note", string2, string);
    }

    public void setPhone(String[] stringArray) {
        String[] stringArray2 = this.fieldPhone;
        this.fieldPhone = stringArray;
        this.firePropertyChange("phone", stringArray2, stringArray);
    }

    public void setPhone(int n, String string) {
        String[] stringArray = this.fieldPhone;
        this.fieldPhone[n] = string;
        this.firePropertyChange("phone", stringArray, this.fieldPhone);
    }

    public void setPhoneId(int[] nArray) {
        int[] nArray2 = this.fieldPhoneId;
        this.fieldPhoneId = nArray;
        this.firePropertyChange("phoneId", nArray2, nArray);
    }

    public void setPhoneId(int n, int n2) {
        int[] nArray = this.fieldPhoneId;
        this.fieldPhoneId[n] = n2;
        this.firePropertyChange("phoneId", nArray, this.fieldPhoneId);
    }

    public void setState(String string) {
        String string2 = this.fieldState;
        this.fieldState = string;
        this.firePropertyChange("state", string2, string);
    }

    public void setTitle(String string) {
        String string2 = this.fieldTitle;
        this.fieldTitle = string;
        this.firePropertyChange("title", string2, string);
    }

    public void setZipCode(String string) {
        String string2 = this.fieldZipCode;
        this.fieldZipCode = string;
        this.firePropertyChange("zipCode", string2, string);
    }

    public void write(DatFile datFile) throws IOException {
        super.write(datFile);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getName(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getFirst(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getTitle(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getCompany(), true);
        int n = 0;
        while (n < 5) {
            datFile.writeLong(1L);
            datFile.writeLong(this.getPhoneId(n));
            datFile.writeLong(5L);
            datFile.writeLong(0L);
            datFile.writeCString(this.getPhone(n), true);
            ++n;
        }
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getAddress(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getCity(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getState(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getZipCode(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getCountry(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getNote(), true);
        datFile.writeLong(6L);
        datFile.writeLong(this.getIsPrivate() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getCategoryId());
        int n2 = 0;
        while (n2 < 4) {
            datFile.writeLong(5L);
            datFile.writeLong(0L);
            datFile.writeCString(this.getCustom(n2), true);
            ++n2;
        }
        datFile.writeLong(1L);
        datFile.writeLong(this.getDisplayPhoneId());
    }
}

