/*
 * Decompiled with CFR 0.152.
 */
package DateBook;

import DateBook.Entry;
import all.BaseConduit;
import all.Category;
import all.CategoryList;
import all.EntryList;
import ctag.pilot.AppInfo;
import ctag.pilot.DateBookAppInfo;
import ctag.pilot.DateBookRecord;
import ctag.pilot.Record;
import ctag.pilot.hotsync.JSync;
import ctag.pilot.hotsync.SyncException;
import java.util.Enumeration;

public class DateBookConduit
extends BaseConduit {
    public DateBookConduit() {
        this.setConduitName("Date-Conduit");
        this.fieldCreatorID = 1684108389;
        this.fieldDirectory = "datebook";
        this.fieldPriority = 0;
        this.fieldSyncDirection = 0;
        this.fieldIntegrate = 0;
        this.fieldModule = "";
    }

    public AppInfo getAppInfo() {
        return new DateBookAppInfo();
    }

    public int getConduitVersion() {
        return 1;
    }

    protected all.Entry makeEntry(Record record) {
        return new Entry(new DateBookRecord(record, true));
    }

    protected Record makeRecord(all.Entry entry) {
        return ((Entry)entry).getDateBookRecord();
    }

    public void syncAppInfo(JSync jSync, int n) throws SyncException {
        AppInfo appInfo = this.getAppInfo();
        jSync.readAppInfo(n, appInfo);
        CategoryList categoryList = this.datFile.getCategories();
        CategoryList categoryList2 = CategoryList.convert(appInfo.getCategoryAppInfo());
        Category category = null;
        Category category2 = null;
        Enumeration enumeration = categoryList2.elements();
        while (enumeration.hasMoreElements()) {
            category = (Category)enumeration.nextElement();
            category2 = categoryList.searchForID(category.id);
            if (!this.firstSync && !category.isNameDirty() && category2 != null) continue;
            if (category2 != null) {
                categoryList.remove(category2);
            }
            category.nameDirty = false;
            categoryList.add(category);
        }
        Enumeration enumeration2 = categoryList.elements();
        while (enumeration2.hasMoreElements()) {
            category2 = (Category)enumeration2.nextElement();
            category = categoryList2.searchForID(category2.id);
            if (!category2.isNameDirty() && category != null) continue;
            if (category != null) {
                categoryList2.remove(category);
            }
            category2.nameDirty = false;
            categoryList2.add(category2);
        }
        this.datFile.setCategories(categoryList);
        categoryList2.convertTo(appInfo.getCategoryAppInfo());
    }

    public int syncRecords(JSync jSync, int n) throws SyncException {
        Record record = null;
        boolean bl = true;
        jSync.readOpenRecordCount(n);
        EntryList entryList = this.datFile.getEntries();
        all.Entry entry = null;
        int n2 = 0;
        jSync.resetDBIndex(n);
        while (bl) {
            record = new Record();
            bl = this.firstSync ? jSync.readRecordByIndex(n, n2++, record) : jSync.readNextModifiedRecord(n, record);
            if (!bl) continue;
            entry = entryList.searchForID(record.getId());
            if (entry != null) {
                entryList.remove(entry);
            }
            if (record.isDeleted() || record.isArchived()) continue;
            record.modified = false;
            entryList.add(this.makeEntry(record));
        }
        bl = true;
        entryList.resetModifiedIndex();
        while (bl) {
            entry = entryList.getNextModifiedEntry();
            if (entry != null) {
                if (entry.isDeleted() && entry.getId() != 0) continue;
                entry.setModified(false);
                continue;
            }
            bl = false;
        }
        entryList.resetSyncFlags();
        entryList.cleanUp();
        this.datFile.setEntries(entryList);
        return 0;
    }
}

