/*
 * Decompiled with CFR 0.152.
 */
package DateBook;

import DateBook.AdvType;
import DateBook.Repeat;
import all.ConfigFile;
import all.DatFile;
import ctag.pilot.DateBookRecord;
import ctag.pilot.Record;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class Entry
extends all.Entry
implements Serializable {
    ctag.types.Date fieldStartDate;
    ctag.types.Date fieldEndDate;
    ctag.types.Date fieldRepeatEnd;
    boolean fieldIsUntimed = false;
    String fieldDescription = "";
    String fieldNote = "";
    int fieldDuration;
    boolean fieldIsAlarmed = false;
    int fieldAlarmAdvTime;
    Repeat fieldRepeatType;
    boolean fieldRepeatForever = false;
    int fieldRepeatFrequency;
    int fieldRepeatDay;
    boolean[] fieldRepeatDays = new boolean[7];
    int fieldRepeatWeekstart;
    ctag.types.Date[] fieldExceptDates = new ctag.types.Date[0];
    AdvType fieldAlarmAdvType;
    static DateFormat df = new SimpleDateFormat("kk:mm");
    static Calendar cal = new GregorianCalendar();

    public Entry() {
    }

    public Entry(int n) {
        super(n);
    }

    public Entry(DateBookRecord dateBookRecord) {
        super((Record)dateBookRecord);
        this.setStartDate(dateBookRecord.begin.toCtagDate());
        this.setEndDate(dateBookRecord.end.toCtagDate());
        this.setRepeatEnd(dateBookRecord.repeatEnd.toCtagDate());
        this.setIsUntimed(dateBookRecord.isUntimed);
        this.setDescription(dateBookRecord.description);
        this.setNote(dateBookRecord.note);
        this.setDuration(dateBookRecord.duration);
        this.setIsAlarmed(dateBookRecord.isAlarmed);
        this.setAlarmAdvTime(dateBookRecord.alarmAdvTime);
        this.setRepeatType(Repeat.get(dateBookRecord.repeatType));
        this.fieldRepeatForever = dateBookRecord.repeatForever;
        this.fieldRepeatFrequency = dateBookRecord.repeatFrequency;
        this.fieldRepeatDay = dateBookRecord.repeatDay;
        int n = 0;
        while (n < 7) {
            this.fieldRepeatDays[n] = dateBookRecord.repeatDays[n];
            ++n;
        }
        this.fieldRepeatWeekstart = dateBookRecord.repeatWeekstart;
        this.fieldExceptDates = new ctag.types.Date[dateBookRecord.exceptions];
        int n2 = 0;
        while (n2 < dateBookRecord.exceptions) {
            this.fieldExceptDates[n2] = dateBookRecord.exceptDates[n2].toCtagDate();
            ++n2;
        }
    }

    public int getAlarmAdvTime() {
        return this.fieldAlarmAdvTime;
    }

    public AdvType getAlarmAdvType() {
        block2: {
            if (this.fieldAlarmAdvType != null) break block2;
            try {
                this.fieldAlarmAdvType = AdvType.get(0);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating alarmAdvType property.");
            }
        }
        return this.fieldAlarmAdvType;
    }

    public String getBrowseString(boolean bl) {
        String string;
        if (ConfigFile.getHideState() && this.getIsPrivate()) {
            return null;
        }
        new SimpleDateFormat("HH:mm");
        if (this.getIsUntimed()) {
            string = "* " + this.getDescription();
        } else if (bl) {
            string = "\u250c" + df.format((Date)this.getStartDate());
            string = String.valueOf(string) + " " + this.getDescription();
        } else {
            string = "\u2514" + df.format((Date)this.getEndDate());
        }
        return string;
    }

    public DateBookRecord getDateBookRecord() {
        DateBookRecord dateBookRecord = new DateBookRecord(super.getRecord(), false);
        dateBookRecord.description = this.getDescription();
        dateBookRecord.duration = this.getDuration();
        dateBookRecord.end.fromCtagDate(this.getEndDate());
        dateBookRecord.begin.fromCtagDate(this.getStartDate());
        dateBookRecord.isAlarmed = this.getIsAlarmed();
        dateBookRecord.isUntimed = this.getIsUntimed();
        dateBookRecord.note = this.getNote();
        dateBookRecord.repeatEnd.fromCtagDate(this.getRepeatEnd());
        dateBookRecord.repeatType = this.getRepeatType().getValue();
        dateBookRecord.alarmAdvTime = this.getAlarmAdvTime();
        return dateBookRecord;
    }

    public String getDescription() {
        block2: {
            if (this.fieldDescription != null) break block2;
            try {
                this.fieldDescription = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating description property.");
            }
        }
        return this.fieldDescription;
    }

    public int getDuration() {
        return this.fieldDuration;
    }

    public ctag.types.Date getEndDate() {
        block2: {
            if (this.fieldEndDate != null) break block2;
            try {
                this.fieldEndDate = new ctag.types.Date();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating endDate property.");
            }
        }
        return this.fieldEndDate;
    }

    public boolean getIsAlarmed() {
        return this.fieldIsAlarmed;
    }

    public boolean getIsUntimed() {
        return this.fieldIsUntimed;
    }

    public String getNote() {
        block2: {
            if (this.fieldNote != null) break block2;
            try {
                this.fieldNote = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating note property.");
            }
        }
        return this.fieldNote;
    }

    public int getRepeatDaysAsInt() {
        int n = 0;
        int n2 = 0;
        while (n2 < 7) {
            if (this.fieldRepeatDays[n2]) {
                ++n;
            }
            n <<= 1;
            ++n2;
        }
        return n;
    }

    public ctag.types.Date getRepeatEnd() {
        block2: {
            if (this.fieldRepeatEnd != null) break block2;
            try {
                this.fieldRepeatEnd = new ctag.types.Date();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating repeatEnd property.");
            }
        }
        return this.fieldRepeatEnd;
    }

    public Repeat getRepeatType() {
        block2: {
            if (this.fieldRepeatType != null) break block2;
            try {
                this.fieldRepeatType = Repeat.get(0);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating repeatType property.");
            }
        }
        return this.fieldRepeatType;
    }

    public ctag.types.Date getStartDate() {
        block2: {
            if (this.fieldStartDate != null) break block2;
            try {
                this.fieldStartDate = new ctag.types.Date();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating startDate property.");
            }
        }
        return this.fieldStartDate;
    }

    public void read(DatFile datFile) throws IOException {
        super.read(datFile);
        datFile.readLong();
        this.setStartDate(datFile.readDate());
        datFile.readLong();
        this.setEndDate(datFile.readDate());
        datFile.readLong();
        datFile.readLong();
        this.setDescription(datFile.readCString(true));
        datFile.readLong();
        this.setDuration(datFile.readLong());
        datFile.readLong();
        datFile.readLong();
        this.setNote(datFile.readCString(true));
        datFile.readLong();
        this.setIsUntimed(datFile.readLong() != 0);
        datFile.readLong();
        this.setIsPrivate(datFile.readLong() != 0);
        datFile.readLong();
        this.setCategoryId(datFile.readLong());
        datFile.readLong();
        this.setIsAlarmed(datFile.readLong() != 0);
        datFile.readLong();
        this.setAlarmAdvTime(datFile.readLong());
        datFile.readLong();
        this.setAlarmAdvType(AdvType.get(datFile.readLong()));
        datFile.readLong();
        if (datFile.readLong() != 0) {
            datFile.readShort();
            datFile.readSString(false);
            this.setRepeatType(Repeat.get(datFile.readLong()));
            this.fieldRepeatFrequency = datFile.readLong();
            this.setRepeatEnd(datFile.readDate());
            switch (this.getRepeatType().getValue()) {
                case 1: {
                    datFile.readLong();
                    datFile.readLong();
                    return;
                }
                case 2: {
                    datFile.readLong();
                    datFile.readLong();
                    this.setRepeatDaysFromInt(datFile.readByte());
                    return;
                }
                case 3: {
                    datFile.readLong();
                    datFile.readLong();
                    this.fieldRepeatDay = datFile.readLong();
                    return;
                }
                case 4: {
                    datFile.readLong();
                    datFile.readLong();
                    return;
                }
                case 5: {
                    datFile.readLong();
                    datFile.readLong();
                    datFile.readLong();
                    return;
                }
            }
        }
    }

    public void setAlarmAdvTime(int n) {
        int n2 = this.fieldAlarmAdvTime;
        this.fieldAlarmAdvTime = n;
        this.firePropertyChange("alarmAdvTime", new Integer(n2), new Integer(n));
    }

    public void setAlarmAdvType(AdvType advType) {
        AdvType advType2 = this.fieldAlarmAdvType;
        this.fieldAlarmAdvType = advType;
        this.firePropertyChange("alarmAdvType", advType2, advType);
    }

    public void setDescription(String string) {
        String string2 = this.fieldDescription;
        this.fieldDescription = string;
        this.firePropertyChange("description", string2, string);
    }

    public void setDuration(int n) {
        int n2 = this.fieldDuration;
        this.fieldDuration = n;
        this.firePropertyChange("duration", new Integer(n2), new Integer(n));
    }

    public void setEndDate(ctag.types.Date date) {
        ctag.types.Date date2 = this.fieldEndDate;
        this.fieldEndDate = date;
        this.firePropertyChange("endDate", date2, date);
    }

    public void setIsAlarmed(boolean bl) {
        boolean bl2 = this.fieldIsAlarmed;
        this.fieldIsAlarmed = bl;
        this.firePropertyChange("isAlarmed", new Boolean(bl2), new Boolean(bl));
    }

    public void setIsUntimed(boolean bl) {
        boolean bl2 = this.fieldIsUntimed;
        this.fieldIsUntimed = bl;
        this.firePropertyChange("isUntimed", new Boolean(bl2), new Boolean(bl));
    }

    public void setNote(String string) {
        String string2 = this.fieldNote;
        this.fieldNote = string;
        this.firePropertyChange("note", string2, string);
    }

    public void setRepeatDaysFromInt(int n) {
        int n2 = 0;
        while (n2 < 7) {
            this.fieldRepeatDays[n2] = (n & 1 << n2) != 0;
            ++n2;
        }
    }

    public void setRepeatEnd(ctag.types.Date date) {
        ctag.types.Date date2 = this.fieldRepeatEnd;
        this.fieldRepeatEnd = date;
        this.firePropertyChange("repeatEnd", date2, date);
    }

    public void setRepeatType(Repeat repeat) {
        Repeat repeat2 = this.fieldRepeatType;
        this.fieldRepeatType = repeat;
        this.firePropertyChange("repeatType", repeat2, repeat);
    }

    public void setStartDate(ctag.types.Date date) {
        ctag.types.Date date2 = this.fieldStartDate;
        this.fieldStartDate = date;
        this.firePropertyChange("startDate", date2, date);
    }

    public void write(DatFile datFile) throws IOException {
        super.write(datFile);
        datFile.writeLong(3L);
        datFile.writeDate(this.getStartDate());
        datFile.writeLong(1L);
        datFile.writeDate(this.getEndDate());
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getDescription(), true);
        datFile.writeLong(1L);
        datFile.writeLong(this.getDuration());
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getNote(), true);
        datFile.writeLong(6L);
        datFile.writeLong(this.getIsUntimed() ? 1 : 0);
        datFile.writeLong(6L);
        datFile.writeLong(this.getIsPrivate() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getCategoryId());
        datFile.writeLong(6L);
        datFile.writeLong(this.getIsAlarmed() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getAlarmAdvTime());
        datFile.writeLong(1L);
        datFile.writeLong(this.getAlarmAdvType().getValue());
        datFile.writeLong(8L);
        datFile.writeLong(this.getRepeatType().getValue());
        if (this.getRepeatType() != Repeat.NONE) {
            datFile.writeShort(1);
            datFile.writeSString(this.getRepeatType().getToken(), false);
            datFile.writeLong(this.getRepeatType().getValue());
            datFile.writeLong(this.fieldRepeatFrequency);
            datFile.writeDate(this.getRepeatEnd());
            switch (this.getRepeatType().getValue()) {
                case 1: {
                    datFile.writeLong(0L);
                    datFile.writeLong(0L);
                    return;
                }
                case 2: {
                    datFile.writeLong(0L);
                    datFile.writeLong(0L);
                    datFile.writeByte((byte)this.getRepeatDaysAsInt());
                    return;
                }
                case 3: {
                    datFile.writeLong(0L);
                    datFile.writeLong(0L);
                    datFile.writeLong(this.fieldRepeatDay);
                    return;
                }
                case 4: {
                    datFile.writeLong(0L);
                    datFile.writeLong(0L);
                    return;
                }
                case 5: {
                    datFile.writeLong(0L);
                    datFile.writeLong(0L);
                    datFile.writeLong(0L);
                    return;
                }
            }
        }
    }
}

