/*
 * Decompiled with CFR 0.152.
 */
package Expense;

public final class Currency {
    private int idx;
    private String symbol;
    private static final String[] names = new String[]{"Australia", "Austria", "Belgium", "Brazil", "Canada", "Denmark", "Finland", "France", "Germany", "Hong Kong", "Iceland", "Ireland", "Italy", "Japan", "Luxemborg", "Mexico", "Netherlands", "New Zealand", "Norway", "Spain", "Sweden", "Switzerland", "United Kingdom", "United States"};
    public static Currency AUSTRALIA = new Currency(0, "AU$");
    public static Currency AUSTRIA = new Currency(1, "S");
    public static Currency BELGIUM = new Currency(2, "BF");
    public static Currency BRAZIL = new Currency(3, "R$");
    public static Currency CANADA = new Currency(4, "$CN");
    public static Currency DENMARK = new Currency(5, "DKK");
    public static Currency FINLAND = new Currency(6, "Mk");
    public static Currency FRANCE = new Currency(7, "FRF");
    public static Currency GERMANY = new Currency(8, "DM");
    public static Currency HONG_KONG = new Currency(9, "HK$");
    public static Currency ICELAND = new Currency(10, "ISK");
    public static Currency IRELAND = new Currency(11, "IR\u00a3");
    public static Currency ITALY = new Currency(12, "Li");
    public static Currency JAPAN = new Currency(13, "Yen");
    public static Currency LUXEMBORG = new Currency(14, "Flux");
    public static Currency MEXICO = new Currency(15, "Pts");
    public static Currency NETHERLANDS = new Currency(16, "Gld");
    public static Currency NEW_ZEALAND = new Currency(17, "SD");
    public static Currency NORWAY = new Currency(18, "NKr");
    public static Currency SPAIN = new Currency(19, "Pts");
    public static Currency SWEDEN = new Currency(20, "SKr");
    public static Currency SWITZERLAND = new Currency(21, "CHF");
    public static Currency UNITED_KINGDOM = new Currency(22, "\u00a3");
    public static Currency UNITED_STATES = new Currency(23, "$");
    private static Currency[] objs = new Currency[24];

    private Currency(int n, String string) {
        this.idx = n;
        this.symbol = string;
    }

    public static Currency get(int n) {
        if (n < names.length) {
            return objs[n];
        }
        return null;
    }

    public static Currency get(String string) {
        int n = 0;
        while (n < names.length) {
            if (names[n].equals(string)) {
                return objs[n];
            }
            ++n;
        }
        return null;
    }

    public String getName() {
        return names[this.idx];
    }

    public static String[] getNames() {
        return names;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getValue() {
        return this.idx;
    }

    public String toString() {
        return "Currency." + names[this.idx];
    }

    static {
        Currency.objs[0] = AUSTRALIA;
        Currency.objs[1] = AUSTRIA;
        Currency.objs[2] = BELGIUM;
        Currency.objs[3] = BRAZIL;
        Currency.objs[4] = CANADA;
        Currency.objs[5] = DENMARK;
        Currency.objs[6] = FINLAND;
        Currency.objs[7] = FRANCE;
        Currency.objs[8] = GERMANY;
        Currency.objs[9] = HONG_KONG;
        Currency.objs[10] = ICELAND;
        Currency.objs[11] = IRELAND;
        Currency.objs[12] = ITALY;
        Currency.objs[13] = JAPAN;
        Currency.objs[14] = LUXEMBORG;
        Currency.objs[15] = MEXICO;
        Currency.objs[16] = NETHERLANDS;
        Currency.objs[17] = NEW_ZEALAND;
        Currency.objs[18] = NORWAY;
        Currency.objs[19] = SPAIN;
        Currency.objs[20] = SWEDEN;
        Currency.objs[21] = SWITZERLAND;
        Currency.objs[22] = UNITED_KINGDOM;
        Currency.objs[23] = UNITED_STATES;
    }
}

