/*
 * Decompiled with CFR 0.152.
 */
package Expense;

import Expense.Currency;
import Expense.Payment;
import Expense.Type;
import all.ConfigFile;
import all.DatFile;
import ctag.exchange.DifDataColoum;
import ctag.exchange.DifEntry;
import ctag.pilot.ExpenseRecord;
import ctag.pilot.Record;
import ctag.types.ByteBuffer;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public final class Entry
extends all.Entry
implements DifEntry {
    ctag.types.Date fieldDate;
    String fieldAmount = "";
    String fieldVendor = "";
    String fieldCity = "";
    String fieldAttendees = "";
    String fieldNote = "";
    Currency fieldCurrency;
    Payment fieldPayment;
    Type fieldType;

    public Entry() {
    }

    public Entry(int n) {
        super(n);
    }

    public Entry(ExpenseRecord expenseRecord) {
        super((Record)expenseRecord);
        this.setDate(expenseRecord.date.toCtagDate());
        this.setType(Type.get(expenseRecord.typeId));
        this.setPayment(Payment.get(expenseRecord.paymentId));
        this.setCurrency(Currency.get(expenseRecord.currencyId));
        this.setAmount(expenseRecord.amount);
        this.setVendor(expenseRecord.vendor);
        this.setCity(expenseRecord.city);
        this.setAttendees(expenseRecord.attendees);
        this.setNote(expenseRecord.note);
    }

    public String getAmount() {
        block2: {
            if (this.fieldAmount != null) break block2;
            try {
                this.fieldAmount = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating amount property.");
            }
        }
        return this.fieldAmount;
    }

    public String getAttendees() {
        block2: {
            if (this.fieldAttendees != null) break block2;
            try {
                this.fieldAttendees = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating attendees property.");
            }
        }
        return this.fieldAttendees;
    }

    public String getBrowseString() {
        if (ConfigFile.getHideState() && this.getIsPrivate()) {
            return null;
        }
        return new String(String.valueOf((String.valueOf(DateFormat.getDateInstance(3).format((Date)this.getDate())) + "    ").substring(0, 7)) + " " + (String.valueOf(this.getType().getName()) + "                   ").substring(0, 10) + " " + this.getCurrency().getSymbol() + " " + this.getAmount());
    }

    public String getCity() {
        block2: {
            if (this.fieldCity != null) break block2;
            try {
                this.fieldCity = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating city property.");
            }
        }
        return this.fieldCity;
    }

    public Currency getCurrency() {
        block2: {
            if (this.fieldCurrency != null) break block2;
            try {
                this.fieldCurrency = Currency.get(0);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating currency property.");
            }
        }
        return this.fieldCurrency;
    }

    public ctag.types.Date getDate() {
        block2: {
            if (this.fieldDate != null) break block2;
            try {
                this.fieldDate = new ctag.types.Date();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating date property.");
            }
        }
        return this.fieldDate;
    }

    public DifDataColoum getDifData(int n) {
        switch (n) {
            case 0: {
                return new DifDataColoum(1, this.fieldAmount);
            }
            case 1: {
                return new DifDataColoum(1, this.fieldCurrency.getSymbol());
            }
            case 2: {
                return new DifDataColoum(1, this.fieldPayment.getName());
            }
            case 3: {
                return new DifDataColoum(1, this.fieldType.getName());
            }
            case 4: {
                return new DifDataColoum(1, this.fieldVendor);
            }
            case 5: {
                return new DifDataColoum(1, this.fieldCity);
            }
            case 6: {
                return new DifDataColoum(1, this.fieldAttendees);
            }
            case 7: {
                return new DifDataColoum(1, this.fieldNote);
            }
        }
        return null;
    }

    public ExpenseRecord getExpenseRecord() {
        ExpenseRecord expenseRecord = new ExpenseRecord(super.getRecord(), false);
        expenseRecord.date.fromCtagDate(this.getDate());
        expenseRecord.typeId = this.getType().getValue();
        expenseRecord.paymentId = this.getPayment().getValue();
        expenseRecord.currencyId = this.getCurrency().getValue();
        expenseRecord.amount = this.getAmount();
        expenseRecord.vendor = this.getVendor();
        expenseRecord.city = this.getCity();
        expenseRecord.attendees = this.getAttendees();
        expenseRecord.note = this.getNote();
        return expenseRecord;
    }

    public String getNote() {
        block2: {
            if (this.fieldNote != null) break block2;
            try {
                this.fieldNote = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating note property.");
            }
        }
        return this.fieldNote;
    }

    public Payment getPayment() {
        block2: {
            if (this.fieldPayment != null) break block2;
            try {
                this.fieldPayment = Payment.get(0);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating payment property.");
            }
        }
        return this.fieldPayment;
    }

    public Type getType() {
        block2: {
            if (this.fieldType != null) break block2;
            try {
                this.fieldType = Type.get(0);
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating type property.");
            }
        }
        return this.fieldType;
    }

    public String getVendor() {
        block2: {
            if (this.fieldVendor != null) break block2;
            try {
                this.fieldVendor = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating vendor property.");
            }
        }
        return this.fieldVendor;
    }

    public void read(DatFile datFile) throws IOException {
        super.read(datFile);
        datFile.readLong();
        this.setDate(datFile.readDate());
        datFile.readLong();
        this.setType(Type.get(datFile.readLong()));
        datFile.readLong();
        this.setPayment(Payment.get(datFile.readLong()));
        datFile.readLong();
        this.setCurrency(Currency.get(datFile.readLong()));
        datFile.readLong();
        datFile.readLong();
        this.setAmount(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setVendor(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setCity(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setAttendees(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setNote(datFile.readCString(true));
        datFile.readLong();
        this.setIsPrivate(datFile.readLong() != 0);
        datFile.readLong();
        this.setCategoryId(datFile.readLong());
    }

    public void setAmount(String string) {
        String string2 = this.fieldAmount;
        this.fieldAmount = string;
        this.firePropertyChange("amount", string2, string);
    }

    public void setAttendees(String string) {
        String string2 = this.fieldAttendees;
        this.fieldAttendees = string;
        this.firePropertyChange("attendees", string2, string);
    }

    public void setCity(String string) {
        String string2 = this.fieldCity;
        this.fieldCity = string;
        this.firePropertyChange("city", string2, string);
    }

    public void setCurrency(Currency currency) {
        Currency currency2 = this.fieldCurrency;
        this.fieldCurrency = currency;
        this.firePropertyChange("currency", currency2, currency);
    }

    public void setDate(ctag.types.Date date) {
        ctag.types.Date date2 = this.fieldDate;
        this.fieldDate = date;
        this.firePropertyChange("date", date2, date);
    }

    public void setNote(String string) {
        String string2 = this.fieldNote;
        this.fieldNote = string;
        this.firePropertyChange("note", string2, string);
    }

    public void setPayment(Payment payment) {
        Payment payment2 = this.fieldPayment;
        this.fieldPayment = payment;
        this.firePropertyChange("payment", payment2, payment);
    }

    public void setType(Type type) {
        Type type2 = this.fieldType;
        this.fieldType = type;
        this.firePropertyChange("type", type2, type);
    }

    public void setVendor(String string) {
        String string2 = this.fieldVendor;
        this.fieldVendor = string;
        this.firePropertyChange("vendor", string2, string);
    }

    public ByteBuffer toBuffer() {
        String string = this.getAmount();
        String string2 = this.getVendor();
        this.getCity();
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.setByte(2, (byte)this.getType().getValue());
        byteBuffer.setByte(3, (byte)this.getPayment().getValue());
        byteBuffer.setByte(4, (byte)this.getCurrency().getValue());
        byteBuffer.setString(6, string);
        byteBuffer.setString(6 + string.length() + 1, string2);
        return byteBuffer;
    }

    public void write(DatFile datFile) throws IOException {
        super.write(datFile);
        datFile.writeLong(3L);
        datFile.writeLong(this.getDate().getTime());
        datFile.writeLong(1L);
        datFile.writeLong(this.getType().getValue());
        datFile.writeLong(1L);
        datFile.writeLong(this.getPayment().getValue());
        datFile.writeLong(1L);
        datFile.writeLong(this.getCurrency().getValue());
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getAmount(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getVendor(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getCity(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getAttendees(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getNote(), true);
        datFile.writeLong(1L);
        datFile.writeLong(this.getIsPrivate() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getCategoryId());
    }
}

