/*
 * Decompiled with CFR 0.152.
 */
package Mail;

import all.ConfigFile;
import all.DatFile;
import ctag.pilot.MailRecord;
import ctag.pilot.Record;
import ctag.types.Date;
import java.io.IOException;
import java.io.PrintStream;
import sun.net.smtp.SmtpClient;

public final class Entry
extends all.Entry {
    boolean fieldRead = false;
    boolean fieldSignature = false;
    boolean fieldConfirmRead = false;
    boolean fieldConfirmDelivery = false;
    int fieldPriority;
    int fieldAddressing;
    Date fieldDate;
    String fieldSubject = "";
    String fieldFrom = "";
    String fieldTo = "";
    String fieldCc = "";
    String fieldBcc = "";
    String fieldReplyTo = "";
    String fieldSentTo = "";
    String fieldBody = "";

    public Entry() {
    }

    public Entry(int n) {
        super(n);
    }

    public Entry(MailRecord mailRecord) {
        super((Record)mailRecord);
        this.setBcc(mailRecord.bcc);
        this.setBody(mailRecord.body);
        this.setCc(mailRecord.cc);
        this.setDate(mailRecord.date.toCtagDate());
        this.setFrom(mailRecord.from);
        this.setPriority(mailRecord.getPriority());
        this.setSubject(mailRecord.subject);
        this.setTo(mailRecord.to);
        this.setReplyTo(mailRecord.replyTo);
        this.setSentTo(mailRecord.sentTo);
        this.setConfirmRead(mailRecord.isConfirmRead());
        this.setConfirmDelivery(mailRecord.isConfirmDelivery());
        this.setAddressing(mailRecord.getAddressing());
        this.setRead(mailRecord.isRead());
    }

    public int getAddressing() {
        return this.fieldAddressing;
    }

    public String getBcc() {
        block2: {
            if (this.fieldBcc != null) break block2;
            try {
                this.fieldBcc = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating bcc property.");
            }
        }
        return this.fieldBcc;
    }

    public String getBody() {
        block2: {
            if (this.fieldBody != null) break block2;
            try {
                this.fieldBody = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating body property.");
            }
        }
        return this.fieldBody;
    }

    public String getBrowseString() {
        return String.valueOf(this.isRead() ? "  " : "* ") + this.getSubject();
    }

    public String getCc() {
        block2: {
            if (this.fieldCc != null) break block2;
            try {
                this.fieldCc = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating cc property.");
            }
        }
        return this.fieldCc;
    }

    public boolean getConfirmDelivery() {
        return this.fieldConfirmDelivery;
    }

    public boolean getConfirmRead() {
        return this.fieldConfirmRead;
    }

    public Date getDate() {
        block2: {
            if (this.fieldDate != null) break block2;
            try {
                this.fieldDate = new Date();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating date property.");
            }
        }
        return this.fieldDate;
    }

    public String getFrom() {
        block2: {
            if (this.fieldFrom != null) break block2;
            try {
                this.fieldFrom = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating from property.");
            }
        }
        return this.fieldFrom;
    }

    public MailRecord getMailRecord() {
        MailRecord mailRecord = new MailRecord(super.getRecord(), false);
        mailRecord.setAddressing(this.getAddressing());
        mailRecord.bcc = this.getBcc();
        mailRecord.body = this.getBody();
        mailRecord.cc = this.getCc();
        mailRecord.from = this.getFrom();
        mailRecord.setPriority(this.getPriority());
        mailRecord.replyTo = this.getReplyTo();
        mailRecord.sentTo = this.getSentTo();
        mailRecord.subject = this.getSubject();
        mailRecord.to = this.getTo();
        mailRecord.date.fromCtagDate(this.getDate());
        mailRecord.setConfirmRead(this.getConfirmRead());
        mailRecord.setConfirmDelivery(this.getConfirmDelivery());
        mailRecord.setAddressing(this.getAddressing());
        mailRecord.setRead(this.isRead());
        return mailRecord;
    }

    public int getPriority() {
        return this.fieldPriority;
    }

    public boolean getRead() {
        return this.fieldRead;
    }

    public String getReplyTo() {
        block2: {
            if (this.fieldReplyTo != null) break block2;
            try {
                this.fieldReplyTo = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating replyTo property.");
            }
        }
        return this.fieldReplyTo;
    }

    public String getSentTo() {
        block2: {
            if (this.fieldSentTo != null) break block2;
            try {
                this.fieldSentTo = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating sentTo property.");
            }
        }
        return this.fieldSentTo;
    }

    public boolean getSignature() {
        return this.fieldSignature;
    }

    public String getSubject() {
        block2: {
            if (this.fieldSubject != null) break block2;
            try {
                this.fieldSubject = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating subject property.");
            }
        }
        return this.fieldSubject;
    }

    public String getTo() {
        block2: {
            if (this.fieldTo != null) break block2;
            try {
                this.fieldTo = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating to property.");
            }
        }
        return this.fieldTo;
    }

    public boolean isRead() {
        return this.fieldRead;
    }

    public void read(DatFile datFile) throws IOException {
        super.read(datFile);
        datFile.readLong();
        this.setDate(datFile.readDate());
        datFile.readLong();
        datFile.readLong();
        this.setSubject(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setFrom(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setTo(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setCc(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setBcc(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setReplyTo(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setSentTo(datFile.readCString(true));
        datFile.readLong();
        datFile.readLong();
        this.setBody(datFile.readCString(true));
        datFile.readLong();
        this.setPriority(datFile.readLong());
        datFile.readLong();
        this.setRead(datFile.readLong() != 0);
        datFile.readLong();
        this.setSignature(datFile.readLong() != 0);
        datFile.readLong();
        this.setConfirmDelivery(datFile.readLong() != 0);
        datFile.readLong();
        this.setConfirmRead(datFile.readLong() != 0);
        datFile.readLong();
        this.setIsPrivate(datFile.readLong() != 0);
    }

    public final void send() throws IOException {
        SmtpClient smtpClient = new SmtpClient(ConfigFile.getSmtpServer());
        smtpClient.from(this.getFrom());
        smtpClient.to(this.getTo());
        PrintStream printStream = smtpClient.startMessage();
        printStream.println(this.getBody());
        printStream.println("** send by jpd **");
        smtpClient.closeServer();
    }

    public void setAddressing(int n) {
        int n2 = this.fieldAddressing;
        this.fieldAddressing = n;
        this.firePropertyChange("addressing", new Integer(n2), new Integer(n));
    }

    public void setBcc(String string) {
        String string2 = this.fieldBcc;
        this.fieldBcc = string;
        this.firePropertyChange("bcc", string2, string);
    }

    public void setBody(String string) {
        String string2 = this.fieldBody;
        this.fieldBody = string;
        this.firePropertyChange("body", string2, string);
    }

    public void setCc(String string) {
        String string2 = this.fieldCc;
        this.fieldCc = string;
        this.firePropertyChange("cc", string2, string);
    }

    public void setConfirmDelivery(boolean bl) {
        boolean bl2 = this.fieldConfirmDelivery;
        this.fieldConfirmDelivery = bl;
        this.firePropertyChange("confirmDelivery", new Boolean(bl2), new Boolean(bl));
    }

    public void setConfirmRead(boolean bl) {
        boolean bl2 = this.fieldConfirmRead;
        this.fieldConfirmRead = bl;
        this.firePropertyChange("confirmRead", new Boolean(bl2), new Boolean(bl));
    }

    public void setDate(Date date) {
        Date date2 = this.fieldDate;
        this.fieldDate = date;
        this.firePropertyChange("date", date2, date);
    }

    public void setFrom(String string) {
        String string2 = this.fieldFrom;
        this.fieldFrom = string;
        this.firePropertyChange("from", string2, string);
    }

    public void setPriority(int n) {
        int n2 = this.fieldPriority;
        this.fieldPriority = n;
        this.firePropertyChange("priority", new Integer(n2), new Integer(n));
    }

    public void setRead(boolean bl) {
        boolean bl2 = this.fieldRead;
        this.fieldRead = bl;
        this.firePropertyChange("read", new Boolean(bl2), new Boolean(bl));
    }

    public void setReplyTo(String string) {
        String string2 = this.fieldReplyTo;
        this.fieldReplyTo = string;
        this.firePropertyChange("replyTo", string2, string);
    }

    public void setSentTo(String string) {
        String string2 = this.fieldSentTo;
        this.fieldSentTo = string;
        this.firePropertyChange("sentTo", string2, string);
    }

    public void setSignature(boolean bl) {
        boolean bl2 = this.fieldSignature;
        this.fieldSignature = bl;
        this.firePropertyChange("signature", new Boolean(bl2), new Boolean(bl));
    }

    public void setSubject(String string) {
        String string2 = this.fieldSubject;
        this.fieldSubject = string;
        this.firePropertyChange("subject", string2, string);
    }

    public void setTo(String string) {
        String string2 = this.fieldTo;
        this.fieldTo = string;
        this.firePropertyChange("to", string2, string);
    }

    public void write(DatFile datFile) throws IOException {
        super.write(datFile);
        datFile.writeLong(3L);
        datFile.writeLong(this.getDate().getTime());
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getSubject(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getFrom(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getTo(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getCc(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getBcc(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getReplyTo(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getSentTo(), true);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getBody(), true);
        datFile.writeLong(1L);
        datFile.writeLong(this.getPriority());
        datFile.writeLong(1L);
        datFile.writeLong(this.isRead() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getSignature() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getConfirmDelivery() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getConfirmRead() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getIsPrivate() ? 1 : 0);
    }
}

