/*
 * Decompiled with CFR 0.152.
 */
package Memo;

import all.ConfigFile;
import all.DatFile;
import ctag.pilot.MemoRecord;
import ctag.pilot.Record;
import ctag.types.ByteBuffer;
import java.io.IOException;
import java.io.Serializable;

public final class Entry
extends all.Entry
implements Serializable {
    String fieldText = "";
    String fieldNote = "";

    public Entry() {
    }

    public Entry(int n) {
        super(n);
    }

    public Entry(MemoRecord memoRecord) {
        super((Record)memoRecord);
        if (memoRecord.text != null) {
            this.setText(memoRecord.text);
        }
    }

    public String getBrowseString() {
        if (ConfigFile.getHideState() && this.getIsPrivate()) {
            return null;
        }
        int n = this.fieldText.indexOf(13);
        if (n < 0) {
            n = this.fieldText.indexOf(10);
        }
        if (n < 0) {
            n = 20;
        }
        if (n > this.fieldText.length()) {
            n = this.fieldText.length();
        }
        return new String(this.fieldText.substring(0, n));
    }

    public String getListText() {
        return this.fieldText.substring(0, this.fieldText.indexOf(10) - 1);
    }

    public MemoRecord getMemoRecord() {
        MemoRecord memoRecord = new MemoRecord(super.getRecord(), false);
        memoRecord.text = this.fieldText;
        return memoRecord;
    }

    public String getNote() {
        block2: {
            if (this.fieldNote != null) break block2;
            try {
                this.fieldNote = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating note property.");
            }
        }
        return this.fieldNote;
    }

    public String getText() {
        block2: {
            if (this.fieldText != null) break block2;
            try {
                this.fieldText = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating text property.");
            }
        }
        return this.fieldText;
    }

    public void read(DatFile datFile) throws IOException {
        super.read(datFile);
        datFile.readLong();
        datFile.readLong();
        this.setText(datFile.readCString(true));
        datFile.readLong();
        this.setIsPrivate(datFile.readLong() != 0);
        datFile.readLong();
        this.setCategoryId(datFile.readLong());
    }

    public void setNote(String string) {
        this.fieldNote = string;
    }

    public void setText(String string) {
        this.fieldText = string;
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendString(this.getText());
        return byteBuffer;
    }

    public String toString() {
        return "[MemoEntry: " + super.toString() + "," + this.fieldText + "]";
    }

    public void write(DatFile datFile) throws IOException {
        super.write(datFile);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getText(), true);
        datFile.writeLong(6L);
        datFile.writeLong(this.getIsPrivate() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getCategoryId());
    }
}

