/*
 * Decompiled with CFR 0.152.
 */
package Memo;

import Memo.Entry;
import all.ConfigFile;
import all.DatFile;
import all.EntryList;
import ctag.pilot.MemoRecord;
import ctag.pilot.PilotFile;
import ctag.pilot.Record;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public final class MemoFile
extends DatFile {
    private String fieldFile = "memopad\\memopad.dat";

    public MemoFile() {
        this.Token = 1297088768L;
        this.Header = "0 0 0 0 1 XOOO";
        this.FieldTypes = new short[6];
        this.FieldTypes[5] = 1;
        this.FieldTypes[2] = 1;
        this.FieldTypes[1] = 1;
        this.FieldTypes[0] = 1;
        this.FieldTypes[3] = 5;
        this.FieldTypes[4] = 6;
        this.TabDesc[1] = 6L;
    }

    public void importPDB(String string) {
        try {
            System.out.println("Importing " + string);
            PilotFile pilotFile = new PilotFile(string, "r");
            pilotFile.read();
            EntryList entryList = new EntryList(pilotFile.getNumOfRecords(), 1);
            int n = 1;
            while (n < pilotFile.getNumOfRecords()) {
                Record record = (Record)pilotFile.getRecords().elementAt(n);
                pilotFile.readRecord(record);
                entryList.add(new Entry(new MemoRecord(record, true)));
                ++n;
            }
            pilotFile.close();
            entryList.sort();
            this.setEntries(entryList);
            this.setWriteOk(false);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            System.out.println("Could not read Memo-Data!");
            System.out.println(iOException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public final Entry makeNewEntry(int n) {
        return new Entry(n);
    }

    public void read() {
        try {
            this.open(String.valueOf(ConfigFile.getDataPath()) + this.fieldFile, true);
            this.readHeader();
            this.readCategories();
            this.readTableDescription();
            int n = this.readLong() / 6;
            EntryList entryList = new EntryList(n, 1);
            Entry entry = null;
            int n2 = 0;
            while (n2 < n) {
                entry = new Entry();
                entry.read(this);
                entryList.add(entry);
                ++n2;
            }
            this.fis.close();
            this.setEntries(entryList);
            this.setWriteOk(false);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            System.out.println("Could not read Memopad-Data!");
            return;
        }
    }

    public static final synchronized MemoFile readData() {
        MemoFile memoFile = null;
        try {
            FileInputStream fileInputStream = new FileInputStream("e:\\memo.ser");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            memoFile = (MemoFile)objectInputStream.readObject();
            fileInputStream.close();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
        return memoFile;
    }

    public void saveEntry(Entry entry) {
        if (!this.getEntries().contains(entry)) {
            this.getEntries().add(entry);
        }
        this.setWriteOk(true);
    }

    public void write() {
        if (!this.getWriteOk()) {
            return;
        }
        try {
            this.open(String.valueOf(ConfigFile.getDataPath()) + this.fieldFile, false);
            this.writeHeader();
            this.writeCategories();
            this.writeTableDescription();
            this.writeLong(this.getEntries().size() * 6);
            Enumeration enumeration = this.getEntries().elements();
            while (enumeration.hasMoreElements()) {
                ((Entry)enumeration.nextElement()).write(this);
            }
            this.fos.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("IOEXPECTION during write! " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
    }

    public final synchronized void writeData() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("e:\\memo.ser");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            return;
        }
    }
}

