/*
 * Decompiled with CFR 0.152.
 */
package Todo;

import all.ConfigFile;
import all.DatFile;
import ctag.pilot.Record;
import ctag.pilot.ToDoRecord;
import ctag.types.ByteBuffer;
import ctag.types.Date;
import java.io.IOException;

public final class Entry
extends all.Entry {
    String fieldDescription = "";
    boolean fieldCompleted = false;
    int fieldPriority;
    String fieldNote = "";
    Date fieldDueDate;

    public Entry() {
    }

    public Entry(int n) {
        super(n);
    }

    public Entry(ToDoRecord toDoRecord) {
        super((Record)toDoRecord);
        this.setDescription(toDoRecord.description);
        this.setNote(toDoRecord.note);
        this.setPriority(toDoRecord.priority);
        this.setCompleted(toDoRecord.completed);
        this.setDueDate(toDoRecord.due.toCtagDate());
    }

    public int compare(Object object) {
        int n = this.fieldPriority - ((Entry)object).fieldPriority;
        if (n == 0) {
            return ((Entry)object).fieldDescription.compareTo(this.fieldDescription);
        }
        return n;
    }

    public String getBrowseString() {
        if (ConfigFile.getHideState() && this.getIsPrivate()) {
            return null;
        }
        if (!ConfigFile.getTodoShowCompleted() && this.getCompleted()) {
            return null;
        }
        return new String(String.valueOf(this.fieldCompleted ? "*" : " ") + " " + this.fieldPriority + " " + this.fieldDescription);
    }

    public boolean getCompleted() {
        return this.fieldCompleted;
    }

    public String getDescription() {
        block2: {
            if (this.fieldDescription != null) break block2;
            try {
                this.fieldDescription = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating description property.");
            }
        }
        return this.fieldDescription;
    }

    public Date getDueDate() {
        return this.fieldDueDate;
    }

    public String getLookupString() {
        return new String(this.fieldDescription);
    }

    public String getNote() {
        block2: {
            if (this.fieldNote != null) break block2;
            try {
                this.fieldNote = new String();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating note property.");
            }
        }
        return this.fieldNote;
    }

    public int getPriority() {
        return this.fieldPriority;
    }

    public ToDoRecord getTodoRecord() {
        ToDoRecord toDoRecord = new ToDoRecord(super.getRecord(), false);
        toDoRecord.description = this.getDescription();
        toDoRecord.note = this.getNote();
        toDoRecord.priority = (byte)this.getPriority();
        toDoRecord.completed = this.getCompleted();
        toDoRecord.due.fromCtagDate(this.getDueDate());
        return toDoRecord;
    }

    public void read(DatFile datFile) throws IOException {
        super.read(datFile);
        datFile.readLong();
        datFile.readLong();
        this.setDescription(datFile.readCString(true));
        datFile.readLong();
        this.setDueDate(datFile.readDate());
        datFile.readLong();
        this.setCompleted(datFile.readLong() != 0);
        datFile.readLong();
        this.setPriority(datFile.readLong());
        datFile.readLong();
        this.setIsPrivate(datFile.readLong() != 0);
        datFile.readLong();
        this.setCategoryId(datFile.readLong());
        datFile.readLong();
        datFile.readLong();
        this.setNote(datFile.readCString(true));
    }

    public void setCompleted(boolean bl) {
        boolean bl2 = this.fieldCompleted;
        this.fieldCompleted = bl;
        this.firePropertyChange("completed", new Boolean(bl2), new Boolean(bl));
    }

    public void setDescription(String string) {
        String string2 = this.fieldDescription;
        this.fieldDescription = string;
        this.firePropertyChange("description", string2, string);
    }

    public void setDueDate(Date date) {
        Date date2 = this.fieldDueDate;
        this.fieldDueDate = date;
        this.firePropertyChange("dueDate", date2, date);
    }

    public void setNote(String string) {
        String string2 = this.fieldNote;
        this.fieldNote = string;
        this.firePropertyChange("note", string2, string);
    }

    public void setPriority(int n) {
        int n2 = this.fieldPriority;
        this.fieldPriority = n;
        this.firePropertyChange("priority", new Integer(n2), new Integer(n));
    }

    public ByteBuffer toBuffer() {
        ByteBuffer byteBuffer = new ByteBuffer(1);
        byteBuffer.appendString(this.getDescription());
        byteBuffer.appendString(this.getNote());
        return byteBuffer;
    }

    public String toString() {
        return "[MemoEntry: " + super.toString() + "," + String.valueOf(this.getCompleted()) + "," + String.valueOf(this.getPriority()) + "]";
    }

    public void write(DatFile datFile) throws IOException {
        super.write(datFile);
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getDescription(), true);
        datFile.writeLong(3L);
        datFile.writeDate(this.getDueDate());
        datFile.writeLong(6L);
        datFile.writeLong(this.getCompleted() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getPriority());
        datFile.writeLong(6L);
        datFile.writeLong(this.getIsPrivate() ? 1 : 0);
        datFile.writeLong(1L);
        datFile.writeLong(this.getCategoryId());
        datFile.writeLong(5L);
        datFile.writeLong(0L);
        datFile.writeCString(this.getNote(), true);
    }
}

