/*
 * Decompiled with CFR 0.152.
 */
package Todo;

import Todo.Entry;
import all.ConfigFile;
import all.DatFile;
import all.EntryList;
import ctag.pilot.PilotFile;
import ctag.pilot.Record;
import ctag.pilot.ToDoRecord;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;

public final class TodoFile
extends DatFile {
    private String fieldFile = "todo\\todo.dat";

    public TodoFile() {
        this.Token = 1094844672L;
        this.Header = "16 0 0 1 1 0 0 1 0 XOOOOOO";
        this.FieldTypes = new short[10];
        this.FieldTypes[8] = 1;
        this.FieldTypes[6] = 1;
        this.FieldTypes[2] = 1;
        this.FieldTypes[1] = 1;
        this.FieldTypes[0] = 1;
        this.FieldTypes[9] = 5;
        this.FieldTypes[3] = 5;
        this.FieldTypes[7] = 6;
        this.FieldTypes[5] = 6;
        this.FieldTypes[4] = 3;
        this.TabDesc[1] = 10L;
    }

    public void importPDB(String string) {
        try {
            System.out.println("Importing " + string);
            PilotFile pilotFile = new PilotFile(string, "r");
            pilotFile.read();
            EntryList entryList = new EntryList(pilotFile.getNumOfRecords(), 1);
            int n = 1;
            while (n < pilotFile.getNumOfRecords()) {
                Record record = (Record)pilotFile.getRecords().elementAt(n);
                pilotFile.readRecord(record);
                entryList.add(new Entry(new ToDoRecord(record, true)));
                ++n;
            }
            pilotFile.close();
            entryList.sort();
            this.setEntries(entryList);
            this.setWriteOk(false);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            System.out.println("Could not read Memo-Data!");
            System.out.println(iOException.getMessage());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public final Entry makeNewEntry(int n) {
        return new Entry(n);
    }

    public void read() {
        try {
            this.open(String.valueOf(ConfigFile.getDataPath()) + this.fieldFile, true);
            this.readHeader();
            this.readCategories();
            this.readTableDescription();
            int n = this.readLong() / 10;
            EntryList entryList = new EntryList(n, 1);
            Entry entry = null;
            int n2 = 0;
            while (n2 < n) {
                entry = new Entry();
                entry.read(this);
                entryList.add(entry);
                ++n2;
            }
            this.fis.close();
            entryList.sort();
            this.setEntries(entryList);
            this.setWriteOk(false);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            System.out.println("Could not read Todo-Data!");
            return;
        }
    }

    public void saveEntry(Entry entry) {
        if (!this.getEntries().contains(entry)) {
            this.getEntries().add(entry);
        }
        this.setWriteOk(true);
    }

    public void write() {
        if (!this.getWriteOk()) {
            return;
        }
        try {
            this.open(String.valueOf(ConfigFile.getDataPath()) + this.fieldFile, false);
            this.writeHeader();
            this.writeCategories();
            this.writeTableDescription();
            this.writeLong(this.getEntries().size() * 10);
            Enumeration enumeration = this.getEntries().elements();
            while (enumeration.hasMoreElements()) {
                ((Entry)enumeration.nextElement()).write(this);
            }
            this.fos.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("EXPECTION during write! " + iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
    }
}

