/*
 * Decompiled with CFR 0.152.
 */
package all;

import all.Category;
import all.CategoryList;
import all.DatFile;
import all.Entry;
import all.EntryList;
import ctag.pilot.AppInfo;
import ctag.pilot.DBInfo;
import ctag.pilot.Record;
import ctag.pilot.cdk.Conduit;
import ctag.pilot.hotsync.JSync;
import ctag.pilot.hotsync.SyncException;
import java.util.Enumeration;

public abstract class BaseConduit
extends Conduit {
    protected DatFile datFile;
    protected boolean firstSync = false;

    public abstract AppInfo getAppInfo();

    public abstract int getConduitVersion();

    protected abstract Entry makeEntry(Record var1);

    protected abstract Record makeRecord(Entry var1);

    public void run(JSync jSync, DBInfo dBInfo) {
        block6: {
            byte by = -1;
            if (this.datFile == null || jSync == null) {
                return;
            }
            try {
                this.firstSync = this.datFile.getEntries().size() == 0;
                by = jSync.openDB(-64, dBInfo.name);
                if (by != -1) {
                    this.syncAppInfo(jSync, by);
                    this.syncRecords(jSync, by);
                    jSync.closeDB(by);
                    this.datFile.setWriteOk(true);
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (by == -1) break block6;
                try {
                    jSync.closeDB(by);
                    return;
                }
                catch (Exception exception2) {
                    return;
                }
            }
        }
    }

    public void setDatFile(DatFile datFile) {
        this.datFile = datFile;
    }

    public void syncAppInfo(JSync jSync, int n) throws SyncException {
        AppInfo appInfo = this.getAppInfo();
        jSync.readAppInfo(n, appInfo);
        CategoryList categoryList = this.datFile.getCategories();
        CategoryList categoryList2 = CategoryList.convert(appInfo.getCategoryAppInfo());
        Category category = null;
        Category category2 = null;
        Enumeration enumeration = categoryList2.elements();
        while (enumeration.hasMoreElements()) {
            category = (Category)enumeration.nextElement();
            category2 = categoryList.searchForID(category.id);
            if (!this.firstSync && !category.isNameDirty() && category2 != null) continue;
            if (category2 != null) {
                categoryList.remove(category2);
            }
            category.nameDirty = false;
            categoryList.add(category);
        }
        Enumeration enumeration2 = categoryList.elements();
        while (enumeration2.hasMoreElements()) {
            category2 = (Category)enumeration2.nextElement();
            category = categoryList2.searchForID(category2.id);
            if (!category2.isNameDirty() && category != null) continue;
            if (category != null) {
                categoryList2.remove(category);
            }
            category2.nameDirty = false;
            categoryList2.add(category2);
        }
        this.datFile.setCategories(categoryList);
        categoryList2.convertTo(appInfo.getCategoryAppInfo());
        jSync.writeAppInfo(n, appInfo);
    }

    public int syncRecords(JSync jSync, int n) throws SyncException {
        Record record = null;
        boolean bl = true;
        jSync.readOpenRecordCount(n);
        EntryList entryList = this.datFile.getEntries();
        Entry entry = null;
        int n2 = 0;
        jSync.resetDBIndex(n);
        while (bl) {
            record = new Record();
            bl = this.firstSync ? jSync.readRecordByIndex(n, n2++, record) : jSync.readNextModifiedRecord(n, record);
            if (!bl) continue;
            entry = entryList.searchForID(record.getId());
            if (entry != null) {
                entryList.remove(entry);
            }
            if (record.isDeleted() || record.isArchived()) continue;
            record.modified = false;
            entryList.add(this.makeEntry(record));
        }
        bl = true;
        entryList.resetModifiedIndex();
        while (bl) {
            entry = entryList.getNextModifiedEntry();
            if (entry != null) {
                if (entry.isDeleted() && entry.getId() != 0) {
                    jSync.deleteRecord(n, entry.getId(), false);
                    continue;
                }
                entry.setModified(false);
                entry.setId(jSync.writeRecord(n, this.makeRecord(entry)));
                continue;
            }
            bl = false;
        }
        jSync.resetSyncFlags(n);
        entryList.resetSyncFlags();
        jSync.cleanUpDatabase(n);
        entryList.cleanUp();
        this.datFile.setEntries(entryList);
        return 0;
    }
}

