/*
 * Decompiled with CFR 0.152.
 */
package all;

import all.BrowsePanelListener;
import all.BrowsePanelListenerEventMulticaster;
import all.BrowserListFiller;
import all.Category;
import all.CategoryList;
import all.Entry;
import all.EntryList;
import all.MsgBox;
import ctag.config.Settings;
import ctag.menu.CMenuItem;
import ctag.output.NlsLabel;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;

public class BrowsePanel
extends Panel
implements ActionListener,
ItemListener,
KeyListener,
MouseListener,
TextListener {
    CategoryList fieldCategories;
    int fieldCatId;
    EntryList fieldEntries;
    Entry fieldSelectedEntry;
    boolean fieldWriteOk = false;
    protected transient BrowsePanelListener ivjBrowsePanelListenerEventMulticaster;
    private Choice ivjCategoryChoice;
    private CMenuItem ivjCMenuItem1;
    private List ivjEntryList;
    private TextField ivjLookupText;
    private CMenuItem ivjNewMenuItem;
    private NlsLabel ivjNlsLabel1;
    private PopupMenu ivjPopupMenu1;
    private MsgBox ivjMsgBox;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public BrowsePanel() {
        this.initialize();
    }

    public BrowsePanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getCMenuItem1()) {
            this.conn4(actionEvent);
        }
        if (actionEvent.getSource() == this.getNewMenuItem()) {
            this.promConn6(actionEvent);
        }
    }

    public void addBrowsePanelListener(BrowsePanelListener browsePanelListener) {
        this.ivjBrowsePanelListenerEventMulticaster = BrowsePanelListenerEventMulticaster.add(this.ivjBrowsePanelListenerEventMulticaster, browsePanelListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    private void conn0(ItemEvent itemEvent) {
        try {
            this.processSelection();
            return;
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return;
        }
    }

    private void conn12(TextEvent textEvent) {
        try {
            this.lookUp();
            return;
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return;
        }
    }

    private void conn15(ItemEvent itemEvent) {
        try {
            this.refreshEntryList();
            return;
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return;
        }
    }

    private void conn2(MouseEvent mouseEvent) {
        try {
            this.processPopupMenu(mouseEvent);
            return;
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return;
        }
    }

    private void conn4(ActionEvent actionEvent) {
        try {
            this.processDelete();
            return;
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return;
        }
    }

    private void conn5(KeyEvent keyEvent) {
        try {
            this.processKeys(keyEvent);
            return;
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return;
        }
    }

    private void fillCategoryChoice() {
        this.getCategoryChoice().removeAll();
        this.getCategoryChoice().add(Settings.getNLSString((String)"All"));
        Enumeration enumeration = this.getCategories().elements();
        while (enumeration.hasMoreElements()) {
            this.getCategoryChoice().add(((Category)enumeration.nextElement()).getLongName());
        }
        this.getCategoryChoice().select(Settings.getNLSString((String)"All"));
    }

    protected void fireNewMenuItemAction_actionPerformed(EventObject eventObject) {
        if (this.ivjBrowsePanelListenerEventMulticaster == null) {
            return;
        }
        this.ivjBrowsePanelListenerEventMulticaster.newMenuItemAction_actionPerformed(eventObject);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChange.firePropertyChange(string, object, object2);
    }

    public CategoryList getCategories() {
        block2: {
            if (this.fieldCategories != null) break block2;
            try {
                this.fieldCategories = new CategoryList();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating categories property.");
            }
        }
        return this.fieldCategories;
    }

    private Choice getCategoryChoice() {
        block2: {
            if (this.ivjCategoryChoice != null) break block2;
            try {
                this.ivjCategoryChoice = new Choice();
                this.ivjCategoryChoice.setName("CategoryChoice");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCategoryChoice;
    }

    public int getCategoryChoiceSelectedIndex() {
        return this.getCategoryChoice().getSelectedIndex();
    }

    public int getCatId() {
        return this.fieldCatId;
    }

    private CMenuItem getCMenuItem1() {
        block2: {
            if (this.ivjCMenuItem1 != null) break block2;
            try {
                this.ivjCMenuItem1 = new CMenuItem();
                this.ivjCMenuItem1.setLabel("Delete");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCMenuItem1;
    }

    public EntryList getEntries() {
        block2: {
            if (this.fieldEntries != null) break block2;
            try {
                this.fieldEntries = new EntryList();
            }
            catch (Throwable throwable) {
                System.err.println("Exception creating entries property.");
            }
        }
        return this.fieldEntries;
    }

    private List getEntryList() {
        block2: {
            if (this.ivjEntryList != null) break block2;
            try {
                this.ivjEntryList = new List();
                this.ivjEntryList.setName("EntryList");
                this.ivjEntryList.setFont(new Font("monospaced", 0, 12));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjEntryList;
    }

    private TextField getLookupText() {
        block2: {
            if (this.ivjLookupText != null) break block2;
            try {
                this.ivjLookupText = new TextField();
                this.ivjLookupText.setName("LookupText");
                this.ivjLookupText.setColumns(20);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjLookupText;
    }

    private MsgBox getMsgBox() {
        block2: {
            if (this.ivjMsgBox != null) break block2;
            try {
                this.ivjMsgBox = new MsgBox(new Frame(), "Delete entry?", "Are you sure?", true);
                this.ivjMsgBox.setName("MsgBox");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMsgBox;
    }

    private CMenuItem getNewMenuItem() {
        block2: {
            if (this.ivjNewMenuItem != null) break block2;
            try {
                this.ivjNewMenuItem = new CMenuItem();
                this.ivjNewMenuItem.setLabel("New");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjNewMenuItem;
    }

    private NlsLabel getNlsLabel1() {
        block2: {
            if (this.ivjNlsLabel1 != null) break block2;
            try {
                this.ivjNlsLabel1 = new NlsLabel();
                this.ivjNlsLabel1.setName("NlsLabel1");
                this.ivjNlsLabel1.setText("Look up");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjNlsLabel1;
    }

    private PopupMenu getPopupMenu1() {
        block2: {
            if (this.ivjPopupMenu1 != null) break block2;
            try {
                this.ivjPopupMenu1 = new PopupMenu();
                this.ivjPopupMenu1.setFont(new Font("helvetica", 0, 12));
                this.ivjPopupMenu1.add((MenuItem)this.getNewMenuItem());
                this.ivjPopupMenu1.add((MenuItem)this.getCMenuItem1());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjPopupMenu1;
    }

    public Entry getSelectedEntry() {
        return this.fieldSelectedEntry;
    }

    public boolean getWriteOk() {
        return this.fieldWriteOk;
    }

    private void handleException(Throwable throwable) {
    }

    private void initConnections() {
        this.getEntryList().addItemListener(this);
        this.getEntryList().addMouseListener(this);
        this.getLookupText().addTextListener(this);
        this.getCMenuItem1().addActionListener(this);
        this.getEntryList().addKeyListener(this);
        this.getCategoryChoice().addItemListener(this);
        this.getNewMenuItem().addActionListener(this);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        this.setName("BrowsePanel");
        this.setName("ListPanel");
        this.setLayout(new GridBagLayout());
        this.setSize(271, 553);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        ((GridBagLayout)this.getLayout()).setConstraints(this.getCategoryChoice(), gridBagConstraints);
        this.add(this.getCategoryChoice());
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(0, 3, 0, 3);
        ((GridBagLayout)this.getLayout()).setConstraints(this.getEntryList(), gridBagConstraints2);
        this.add(this.getEntryList());
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.weightx = 2.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.insets = new Insets(5, 0, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.getLookupText(), gridBagConstraints3);
        this.add(this.getLookupText());
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 0.0;
        gridBagConstraints4.insets = new Insets(0, 3, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints((Component)this.getNlsLabel1(), gridBagConstraints4);
        this.add((Component)this.getNlsLabel1());
        this.initConnections();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.getEntryList()) {
            this.conn0(itemEvent);
        }
        if (itemEvent.getSource() == this.getCategoryChoice()) {
            this.conn15(itemEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.getEntryList()) {
            this.conn5(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void lookUp() {
        String string = this.getLookupText().getText();
        if (string.length() > 0) {
            Enumeration enumeration = this.getEntries().elements();
            while (enumeration.hasMoreElements()) {
                Entry entry = (Entry)enumeration.nextElement();
                if (entry.getBrowseIndex() == -1 || !entry.getLookupString().startsWith(string)) continue;
                this.getEntryList().select(entry.getBrowseIndex());
                this.processSelection();
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Frame frame;
            Serializable serializable;
            try {
                serializable = Class.forName("uvm.abt.edit.TestFrame");
                frame = (Frame)((Class)serializable).newInstance();
            }
            catch (Throwable throwable) {
                frame = new Frame();
            }
            serializable = new BrowsePanel();
            frame.add("Center", (Component)serializable);
            ((Component)frame).setSize(((Component)serializable).getSize());
            ((Component)frame).setVisible(true);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of java.awt.Panel");
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.getEntryList()) {
            this.conn2(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void processDelete() {
        if (this.getSelectedEntry() != null) {
            this.getSelectedEntry().setDeleted(true);
            this.getSelectedEntry().setModified(true);
            this.setWriteOk(true);
            this.refreshEntryList();
        }
    }

    private void processKeys(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 155) {
            ActionEvent actionEvent = new ActionEvent(this.getNewMenuItem(), 0, "");
            this.promConn6(actionEvent);
        }
        if (keyEvent.getKeyCode() == 127) {
            this.processDelete();
        }
    }

    private void processPopupMenu(MouseEvent mouseEvent) {
        Component component;
        if (mouseEvent != null && (mouseEvent.getModifiers() & 4) != 0 && (component = mouseEvent.getComponent()) != null) {
            component.add(this.getPopupMenu1());
            this.getPopupMenu1().show(component, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void processSelection() {
        int n = this.getEntryList().getSelectedIndex();
        if (n > -1) {
            Enumeration enumeration = this.getEntries().elements();
            while (enumeration.hasMoreElements()) {
                Entry entry = (Entry)enumeration.nextElement();
                if (entry.getBrowseIndex() != n) continue;
                this.setSelectedEntry(entry);
                return;
            }
            return;
        }
        this.setSelectedEntry(null);
    }

    private void promConn6(ActionEvent actionEvent) {
        try {
            this.fireNewMenuItemAction_actionPerformed(new EventObject(this));
            return;
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return;
        }
    }

    public void refreshEntryList() {
        this.setCatId(this.getCategoryChoice().getSelectedIndex() - 1);
        new BrowserListFiller(this.getEntryList(), this.getEntries(), this.getCategoryChoice().getSelectedIndex()).start();
    }

    public void removeBrowsePanelListener(BrowsePanelListener browsePanelListener) {
        this.ivjBrowsePanelListenerEventMulticaster = BrowsePanelListenerEventMulticaster.remove(this.ivjBrowsePanelListenerEventMulticaster, browsePanelListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void setCategories(CategoryList categoryList) {
        this.fieldCategories = categoryList;
        this.fillCategoryChoice();
    }

    public void setCatId(int n) {
        this.fieldCatId = n;
    }

    public void setEntries(EntryList entryList) {
        this.fieldEntries = entryList;
        this.refreshEntryList();
    }

    public void setSelectedEntry(Entry entry) {
        Entry entry2 = this.fieldSelectedEntry;
        this.fieldSelectedEntry = entry;
        this.firePropertyChange("selectedEntry", entry2, entry);
    }

    public void setWriteOk(boolean bl) {
        boolean bl2 = this.fieldWriteOk;
        this.fieldWriteOk = bl;
        this.firePropertyChange("writeOk", new Boolean(bl2), new Boolean(bl));
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.getLookupText()) {
            this.conn12(textEvent);
        }
    }
}

