/*
 * Decompiled with CFR 0.152.
 */
package all;

import all.DatFile;
import ctag.pilot.Record;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;

public abstract class Entry
implements Serializable {
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    int fieldId;
    int fieldStatus;
    int fieldPosition;
    int fieldCategoryId;
    transient int fieldBrowseIndex;
    boolean fieldIsPrivate = false;
    public static final int AttrDirty = 2;
    public static final int AttrDeleted = 4;
    public static final int AttrBusy = 32;
    public static final int AttrSecret = 16;
    public static final int AttrSaveBackup = 128;

    public Entry() {
    }

    public Entry(int n) {
        if (n == -1) {
            n = 0;
        }
        this.fieldCategoryId = n;
    }

    public Entry(Entry entry) {
        this.fieldId = entry.fieldId;
        this.fieldStatus = entry.fieldStatus;
        this.fieldPosition = entry.fieldPosition;
        this.fieldCategoryId = entry.fieldCategoryId;
        this.fieldIsPrivate = entry.fieldIsPrivate;
    }

    public Entry(Record record) {
        this.fieldId = record.getId();
        this.fieldCategoryId = record.category;
        this.fieldIsPrivate = record.secret;
        this.setModified(record.modified);
        this.setDeleted(record.deleted);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized int compare(Entry entry) {
        return this.fieldId - entry.getId();
    }

    public int compare(Object object) {
        return this.fieldId - ((Entry)object).getId();
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChange.firePropertyChange(string, object, object2);
    }

    public int getBrowseIndex() {
        return this.fieldBrowseIndex;
    }

    public String getBrowseString() {
        return String.valueOf(this.fieldId);
    }

    public int getCategoryId() {
        return this.fieldCategoryId;
    }

    public int getId() {
        return this.fieldId;
    }

    public boolean getIsPrivate() {
        return this.fieldIsPrivate;
    }

    public String getLookupString() {
        return this.getBrowseString();
    }

    public int getPosition() {
        return this.fieldPosition;
    }

    public Record getRecord() {
        Record record = new Record();
        record.setId(this.fieldId);
        record.category = (byte)this.fieldCategoryId;
        record.secret = this.fieldIsPrivate;
        record.modified = this.isModified();
        record.deleted = this.isDeleted();
        return record;
    }

    public int getStatus() {
        return this.fieldStatus;
    }

    public boolean isDeleted() {
        return (this.fieldStatus & 4) != 0;
    }

    public boolean isModified() {
        return (this.fieldStatus & 2) != 0;
    }

    public boolean isSaveBackup() {
        return (this.fieldStatus & 0x80) != 0;
    }

    public void read(DatFile datFile) throws IOException {
        if (datFile.readLong() != 1) {
            throw new IOException("Wrong File Format: (id) Long expected!");
        }
        this.setId(datFile.readLong());
        if (datFile.readLong() != 1) {
            throw new IOException("Wrong File Format: (status) Long expected!");
        }
        this.setStatus(datFile.readLong());
        if (datFile.readLong() != 1) {
            throw new IOException("Wrong File Format: (position) Long expected!");
        }
        this.setPosition(datFile.readLong());
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void setBrowseIndex(int n) {
        this.fieldBrowseIndex = n;
    }

    public void setCategoryId(int n) {
        this.fieldCategoryId = n;
    }

    public void setDeleted(boolean bl) {
        if (bl) {
            this.fieldStatus |= 4;
            return;
        }
        this.fieldStatus &= 0xFFFFFFFB;
    }

    public void setId(int n) {
        this.fieldId = n;
    }

    public void setIsPrivate(boolean bl) {
        this.fieldIsPrivate = bl;
    }

    public void setModified(boolean bl) {
        if (bl) {
            this.fieldStatus |= 2;
            return;
        }
        this.fieldStatus &= 0xFFFFFFFD;
    }

    public void setPosition(int n) {
        this.fieldPosition = n;
    }

    public void setStatus(int n) {
        this.fieldStatus = n;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.fieldId)) + ",D:" + String.valueOf(this.isDeleted()) + ",M:" + String.valueOf(this.isModified());
    }

    public void write(DatFile datFile) throws IOException {
        datFile.writeLong(1L);
        datFile.writeLong(this.getId());
        datFile.writeLong(1L);
        datFile.writeLong(this.getStatus());
        datFile.writeLong(1L);
        datFile.writeLong(this.getPosition());
    }
}

