/*
 * This REXX-Script creates the Java-Pilot-Desktop Folder on your Desktop
 */

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

CreateCollision = 'Update'
JPDPath=directory()

Call CreateObjects
Exit

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateObjects:

rc = CreateObject( 'WPFolder',,
    'Java-Pilot-Desktop',,
    '<WP_DESKTOP>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ICONPOS=85,41;'||,
        'ICONVIEWPOS=27 59 47 14;'||,
        'SELFCLOSE=2;'||,
        'BACKGROUND='JPDPath'\os2\jpd6.gif,T,,I,255 255 255;'||,
        'ICONFONT=9.WarpSans Bold;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'FOLDERICONBACKGROUNDCOLOR=00C1B9FF;'||,
        'ICONFILE='JPDPath'\OS2\Java-Pilot-Desktop.ICO;'||,
        'OBJECTID=<Java_Pilot_Desktop>',,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Java-Pilot-Desktop',,
      '<Java_Pilot_Desktop>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='JPDPath'\RUN.CMD;'||,
          'STARTUPDIR='JPDPath';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='JPDPath'\OS2\Java-Pilot-Desktop1.ICO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'J.P.D. ToDoList',,
      '<Java_Pilot_Desktop>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='JPDPath'\RUNTODO.CMD;'||,
          'STARTUPDIR='JPDPath';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='JPDPath'\OS2\J.ICO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'J.P.D. Address',,
      '<Java_Pilot_Desktop>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='JPDPath'\RUNADDRESS.CMD;'||,
          'STARTUPDIR='JPDPath';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='JPDPath'\OS2\J1.ICO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'J.P.D. MemoPad',,
      '<Java_Pilot_Desktop>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='JPDPath'\RUNMEMO.CMD;'||,
          'STARTUPDIR='JPDPath';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='JPDPath'\OS2\J2.ICO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'J.P.D. Expense',,
      '<Java_Pilot_Desktop>',,
      'NOTDEFAULTICON=YES;'||,
          'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='JPDPath'\RUNEXPENSE.CMD;'||,
          'STARTUPDIR='JPDPath';'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'MINIMIZED=YES;'||,
          'ICONFILE='JPDPath'\OS2\J3.ICO',,
      CreateCollision )

return


