/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jb.util;

import com.borland.jb.util.ChainedException;
import java.io.PrintStream;
import java.io.Serializable;

public class ExceptionChain
implements Serializable {
    private Throwable ex;
    private ExceptionChain next;

    public static String getOriginalMessage(Throwable throwable) {
        Object object;
        while (throwable instanceof ChainedException && (object = ((ChainedException)((Object)throwable)).getExceptionChain()) != null) {
            while (((ExceptionChain)object).getNext() != null) {
                object = ((ExceptionChain)object).getNext();
            }
            throwable = ((ExceptionChain)object).getException();
        }
        object = throwable.getMessage();
        if (object == null || ((String)object).length() == 0 || throwable instanceof ArrayIndexOutOfBoundsException) {
            String string = throwable.getClass().getName();
            object = object == null ? string : String.valueOf(new StringBuffer(String.valueOf(string)).append(" ").append((String)object));
        }
        return object;
    }

    public Throwable getException() {
        return this.ex;
    }

    public ExceptionChain getNext() {
        return this.next;
    }

    public boolean hasExceptions() {
        return this.ex != null;
    }

    private void printStackTrace(ExceptionChain exceptionChain, PrintStream printStream) {
        if (exceptionChain != null && exceptionChain.next != null) {
            exceptionChain.printStackTrace(exceptionChain.next, printStream);
        }
        if (this.ex != null) {
            this.ex.printStackTrace(printStream);
        }
    }

    public void printDiagnosticStackTrace() {
        if (this.next != null) {
            this.next.printDiagnosticStackTrace();
        }
        if (this.ex != null) {
            // empty if block
        }
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(this, printStream);
    }

    public void append(Throwable throwable) {
        if (this.ex == null) {
            this.ex = throwable;
        } else {
            this.next = new ExceptionChain(this.next, throwable);
        }
    }

    private ExceptionChain(ExceptionChain exceptionChain, Throwable throwable) {
        this.next = exceptionChain;
        this.ex = throwable;
    }

    public ExceptionChain() {
    }
}

