/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;

public class GroupBox
extends BeanPanel
implements Serializable {
    static final LayoutManager defaultLayout = new FlowLayout();
    protected String label;
    protected String textureName;

    public GroupBox() {
        super(defaultLayout);
        this.label = "";
        this.focusAware = false;
    }

    public GroupBox(String string) {
        super(defaultLayout);
        this.label = string;
        this.focusAware = false;
    }

    public Dimension getPreferredSize() {
        Font font;
        Dimension dimension = super.getPreferredSize();
        if (this.label != null && !this.label.equals("") && (font = this.getFont()) != null) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
            dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(this.label) + fontMetrics.getHeight() * 2);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setLabel(String string) {
        this.label = string;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public Insets insets() {
        Font font = this.getFont();
        int n = 0;
        if (font != null) {
            n = ((Component)this).getFontMetrics(font).getHeight();
        }
        return new Insets(n, n, n, n);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Font font = graphics.getFont();
        Font font2 = this.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        int n = fontMetrics.getAscent();
        int n2 = n / 2 + 1;
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            return;
        }
        int n3 = n2;
        int n4 = n2;
        int n5 = rectangle.width - n2 - 1;
        int n6 = rectangle.height - n2 - 1;
        graphics.setColor(this.getForeground());
        graphics.drawString(this.label, n3 + n3, n);
        int n7 = fontMetrics.stringWidth(this.label);
        for (int i = 1; i >= 0; --i) {
            graphics.setColor(i == 0 ? SystemColor.controlShadow : SystemColor.controlLtHighlight);
            graphics.drawLine(n3 + n3 - 1, n4 + i, n3 + i, n4 + i);
            graphics.drawLine(n3 + i, n4 + i, n3 + i, n6 + i);
            graphics.drawLine(n3 + i, n6 + i, n5 + i, n6 + i);
            graphics.drawLine(n5 + i, n6 + i, n5 + i, n4 + i);
            graphics.drawLine(n5 + i, n4 + i, n3 + n3 + n7, n4 + i);
        }
        graphics.setFont(font);
    }
}

