/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.ModelEvent;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class VectorModelEvent
extends ModelEvent
implements Serializable {
    private static final long serialVersionUID = 200L;
    public static final int CONTENT_CHANGED = 1;
    public static final int STRUCTURE_CHANGED = 2;
    public static final int ITEM_CHANGED = 17;
    public static final int ITEM_TOUCHED = 33;
    public static final int ITEM_ADDED = 18;
    public static final int ITEM_REMOVED = 34;
    private transient VectorModel model;
    private int change;
    private int location;

    public VectorModelEvent(VectorModel vectorModel, int n) {
        super(vectorModel, n);
        this.model = vectorModel;
        this.change = n;
    }

    public VectorModelEvent(VectorModel vectorModel, int n, int n2) {
        this(vectorModel, n);
        this.location = n2;
    }

    public VectorModel getModel() {
        return this.model;
    }

    public int getChange() {
        return this.change;
    }

    public int getLocation() {
        return this.location;
    }

    public void dispatch(EventListener eventListener) {
        switch (this.getID()) {
            case 1: {
                ((VectorModelListener)eventListener).modelContentChanged(this);
                break;
            }
            case 2: {
                ((VectorModelListener)eventListener).modelStructureChanged(this);
                break;
            }
        }
    }

    protected String paramString() {
        String string;
        switch (this.change) {
            case 1: {
                string = "CONTENT_CHANGED";
                break;
            }
            case 2: {
                string = "STRUCTURE_CHANGED";
                break;
            }
            case 17: {
                string = "ITEM_CHANGED";
                break;
            }
            case 33: {
                string = "ITEM_TOUCHED";
                break;
            }
            case 18: {
                string = "ITEM_ADDED";
                break;
            }
            case 34: {
                string = "ITEM_REMOVED";
                break;
            }
            default: {
                string = "<INVALID>";
            }
        }
        return String.valueOf(new StringBuffer(String.valueOf(super.paramString())).append(",model=").append(this.model).append(",change=").append(string).append(",location=").append(this.location));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof VectorModel) {
            this.model = (VectorModel)object;
        }
    }
}

